/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.CanceledFlowNodeFilterDataDto;
import io.camunda.optimize.service.db.es.filter.QueryFilterES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class CanceledFlowNodeQueryFilterES
implements QueryFilterES<CanceledFlowNodeFilterDataDto> {
    private static final Logger LOG = LoggerFactory.getLogger(CanceledFlowNodeQueryFilterES.class);

    @Override
    public void addFilters(BoolQuery.Builder query, List<CanceledFlowNodeFilterDataDto> flowNodeFilter, FilterContext filterContext) {
        query.filter(flowNodeFilter.stream().map(this::createFilterQueryBuilder).toList());
    }

    private Query createFilterQueryBuilder(CanceledFlowNodeFilterDataDto flowNodeFilter) {
        Query.Builder builder = new Query.Builder();
        builder.bool(b -> {
            for (String value : flowNodeFilter.getValues()) {
                b.should(s -> s.nested(n -> n.path("flowNodeInstances").query(q -> q.bool(bb -> bb.must(m -> m.bool(new BoolQuery.Builder().must(r -> r.exists(e -> e.field(this.nestedCanceledFieldLabel()))).must(r -> r.term(t -> t.field(this.nestedCanceledFieldLabel()).value(true))).build())).must(m -> m.term(t -> t.field(this.nestedActivityIdFieldLabel()).value(value))))).scoreMode(ChildScoreMode.None)));
            }
            return b;
        });
        return builder.build();
    }

    private String nestedActivityIdFieldLabel() {
        return "flowNodeInstances.flowNodeId";
    }

    private String nestedCanceledFieldLabel() {
        return "flowNodeInstances.canceled";
    }
}

