/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.OperatorMultipleValuesFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.BooleanVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.DateVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.OperatorMultipleValuesVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.StringVariableFilterDataDto;
import io.camunda.optimize.service.db.filter.util.OperatorMultipleValuesVariableFilterDataDtoUtil;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.time.ZoneId;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVariableQueryFilterES {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractVariableQueryFilterES.class);

    protected abstract Query.Builder createContainsOneOfTheGivenStringsQueryBuilder(StringVariableFilterDataDto var1);

    protected abstract Query.Builder createContainsOneOfTheGivenStringsQueryBuilder(String var1, List<String> var2);

    protected abstract Query.Builder createContainsGivenStringQuery(String var1, String var2);

    protected abstract Query.Builder createEqualsOneOrMoreValuesQueryBuilder(OperatorMultipleValuesVariableFilterDataDto var1);

    protected abstract Query.Builder createBooleanQueryBuilder(BooleanVariableFilterDataDto var1);

    protected abstract Query.Builder createNumericQueryBuilder(OperatorMultipleValuesVariableFilterDataDto var1);

    protected abstract Query.Builder createDateQueryBuilder(DateVariableFilterDataDto var1, ZoneId var2);

    protected Query.Builder createStringQueryBuilder(StringVariableFilterDataDto stringVarDto) {
        OperatorMultipleValuesVariableFilterDataDtoUtil.validateMultipleValuesFilterDataDto((OperatorMultipleValuesVariableFilterDataDto)stringVarDto);
        if (stringVarDto.hasContainsOperation()) {
            return this.createContainsOneOfTheGivenStringsQueryBuilder(stringVarDto);
        }
        if (stringVarDto.hasEqualsOperation()) {
            return this.createEqualsOneOrMoreValuesQueryBuilder((OperatorMultipleValuesVariableFilterDataDto)stringVarDto);
        }
        String message = String.format("String variable operator [%s] is not supported!", ((OperatorMultipleValuesFilterDataDto)stringVarDto.getData()).getOperator().getId());
        LOG.debug(message);
        throw new OptimizeRuntimeException(message);
    }
}

