/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Buckets;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeBucket;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchCompositeAggregationScroller {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchCompositeAggregationScroller.class);
    private OptimizeElasticsearchClient esClient;
    private SearchRequest searchRequest;
    private Consumer<CompositeBucket> compositeBucketConsumer;
    private Function<Map<String, FieldValue>, SearchRequest> searchRequestProvider;
    private LinkedList<String> pathToAggregation;

    public static ElasticsearchCompositeAggregationScroller create() {
        return new ElasticsearchCompositeAggregationScroller();
    }

    public void consumeAllPages() {
        boolean pageConsumed;
        while (pageConsumed = this.consumePage()) {
        }
    }

    public boolean consumePage() {
        Buckets<CompositeBucket> currentPage = this.getNextPage();
        currentPage.array().forEach(this.compositeBucketConsumer);
        return !currentPage.array().isEmpty();
    }

    private Buckets<CompositeBucket> getNextPage() {
        try {
            SearchResponse searchResponse = this.esClient.search(this.searchRequest, Object.class);
            CompositeAggregate compositeAggregate = this.extractCompositeAggregationResult(searchResponse);
            this.searchRequest = this.searchRequestProvider.apply(compositeAggregate.afterKey());
            return compositeAggregate.buckets();
        }
        catch (IOException e) {
            String reason = String.format("Was not able to get next page of %s aggregation.", this.pathToAggregation.getLast());
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((RuntimeException)((Object)e))) {
                LOG.info("Was not able to get next page of {} aggregation because at least one instance from {} does not exist.", (Object)this.pathToAggregation.getLast(), (Object)this.searchRequest.index());
                return Buckets.of(b -> b.array(List.of()));
            }
            throw e;
        }
    }

    private CompositeAggregate extractCompositeAggregationResult(SearchResponse<?> searchResponse) {
        Map aggregations = searchResponse.aggregations();
        for (int i = 0; i < this.pathToAggregation.size() - 1; ++i) {
            Aggregate agg = (Aggregate)aggregations.get(this.pathToAggregation.get(i));
            aggregations = agg.nested().aggregations();
        }
        return ((Aggregate)aggregations.get(this.pathToAggregation.getLast())).composite();
    }

    public ElasticsearchCompositeAggregationScroller setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        return this;
    }

    public ElasticsearchCompositeAggregationScroller setEsClient(OptimizeElasticsearchClient esClient) {
        this.esClient = esClient;
        return this;
    }

    public ElasticsearchCompositeAggregationScroller setCompositeBucketConsumer(Consumer<CompositeBucket> compositeBucketConsumer) {
        this.compositeBucketConsumer = compositeBucketConsumer;
        return this;
    }

    public ElasticsearchCompositeAggregationScroller setFunction(Function<Map<String, FieldValue>, SearchRequest> generateSR) {
        this.searchRequestProvider = generateSR;
        return this;
    }

    public ElasticsearchCompositeAggregationScroller setPathToAggregation(String ... pathToAggregation) {
        this.pathToAggregation = new LinkedList<String>(Arrays.asList(pathToAggregation));
        return this;
    }
}

