/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.collection;

import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityResponseDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.service.alert.AlertService;
import io.camunda.optimize.service.dashboard.DashboardService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.AuthorizedEntitiesService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CollectionEntityService {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionEntityService.class);
    private final AuthorizedEntitiesService authorizedEntitiesService;
    private final AuthorizedCollectionService authorizedCollectionService;
    private final AlertService alertService;
    private final ReportService reportService;
    private final DashboardService dashboardService;

    public CollectionEntityService(AuthorizedEntitiesService authorizedEntitiesService, AuthorizedCollectionService authorizedCollectionService, AlertService alertService, ReportService reportService, DashboardService dashboardService) {
        this.authorizedEntitiesService = authorizedEntitiesService;
        this.authorizedCollectionService = authorizedCollectionService;
        this.alertService = alertService;
        this.reportService = reportService;
        this.dashboardService = dashboardService;
    }

    public List<EntityResponseDto> getAuthorizedCollectionEntities(String userId, String collectionId) {
        AuthorizedCollectionDefinitionDto authCollectionDto = this.authorizedCollectionService.getAuthorizedCollectionDefinitionOrFail(userId, collectionId);
        List<Object> entities = this.authorizedEntitiesService.getAuthorizedCollectionEntities(userId, collectionId);
        RoleType currentUserResourceRole = authCollectionDto.getCollectionResourceRole();
        entities = entities.stream().filter(Objects::nonNull).peek(entityDto -> entityDto.setCurrentUserRole(currentUserResourceRole)).sorted(Comparator.comparing(EntityResponseDto::getEntityType).thenComparing(EntityResponseDto::getLastModified, Comparator.reverseOrder())).collect(Collectors.toList());
        return entities;
    }

    public List<AlertDefinitionDto> getStoredAlertsForCollection(String userId, String collectionId) {
        return this.alertService.getStoredAlertsForCollection(userId, collectionId);
    }

    public List<AuthorizedReportDefinitionResponseDto> findAndFilterReports(String userId, String collectionId) {
        return this.reportService.findAndFilterReports(userId, collectionId);
    }

    public void copyCollectionEntities(String userId, CollectionDefinitionRestDto collectionDefinitionDto, String newCollectionId) {
        HashMap uniqueReportCopies = new HashMap();
        List<EntityResponseDto> oldCollectionEntities = this.getAuthorizedCollectionEntities(userId, collectionDefinitionDto.getId());
        oldCollectionEntities.forEach(e -> {
            String originalEntityId = e.getId();
            switch (e.getEntityType()) {
                case REPORT: {
                    String entityCopyId = (String)uniqueReportCopies.get(originalEntityId);
                    if (entityCopyId == null) {
                        entityCopyId = this.reportService.copyAndMoveReport(originalEntityId, userId, newCollectionId, e.getName(), (Map<String, String>)uniqueReportCopies, true).getId();
                        uniqueReportCopies.put(originalEntityId, entityCopyId);
                    }
                    this.alertService.copyAndMoveAlerts(originalEntityId, entityCopyId);
                    break;
                }
                case DASHBOARD: {
                    this.dashboardService.copyAndMoveDashboard(originalEntityId, userId, newCollectionId, e.getName(), uniqueReportCopies, true);
                    break;
                }
                default: {
                    throw new OptimizeRuntimeException("You can't copy a " + e.getEntityType().toString().toLowerCase(Locale.ENGLISH) + " to a collection");
                }
            }
        });
    }
}

