/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import io.camunda.optimize.dto.optimize.alert.AlertNotificationDto;
import io.camunda.optimize.dto.optimize.alert.AlertNotificationType;
import io.camunda.optimize.service.alert.AlertNotificationService;
import io.camunda.optimize.service.mixpanel.MixpanelReportingService;
import io.camunda.optimize.service.mixpanel.client.EventReportingEvent;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.util.Optional;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class MixpanelNotificationService
implements AlertNotificationService {
    private final MixpanelReportingService mixpanelReportingService;

    public MixpanelNotificationService(MixpanelReportingService mixpanelReportingService) {
        this.mixpanelReportingService = mixpanelReportingService;
    }

    @Override
    public void notify(AlertNotificationDto notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Notification cannot be null");
        }
        this.mixpanelReportingService.sendEntityEvent(switch (Optional.ofNullable(notification.getType()).orElse(AlertNotificationType.NEW)) {
            case AlertNotificationType.REMINDER -> EventReportingEvent.ALERT_REMINDER_TRIGGERED;
            case AlertNotificationType.RESOLVED -> EventReportingEvent.ALERT_RESOLVED_TRIGGERED;
            default -> EventReportingEvent.ALERT_NEW_TRIGGERED;
        }, notification.getAlert().getId());
    }

    @Override
    public String getNotificationDescription() {
        return "Mixpanel notification";
    }
}

