/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.alert.AlertCreationRequestDto;
import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionVisualization;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.group.DecisionGroupByType;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessVisualization;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.ProcessGroupByType;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemType;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.alert.AlertCheckJobFactory;
import io.camunda.optimize.service.alert.AlertRecipientValidator;
import io.camunda.optimize.service.alert.AlertReminderJobFactory;
import io.camunda.optimize.service.alert.AlertUtil;
import io.camunda.optimize.service.alert.ReminderHandlingListener;
import io.camunda.optimize.service.db.reader.AlertReader;
import io.camunda.optimize.service.db.writer.AlertWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.relations.ReportReferencingService;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.ValidationHelper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;
import org.springframework.stereotype.Component;

@Component
public class AlertService
implements ReportReferencingService {
    private static final Logger LOG = LoggerFactory.getLogger(AlertService.class);
    private final ApplicationContext applicationContext;
    private final AlertReader alertReader;
    private final AlertWriter alertWriter;
    private final ConfigurationService configurationService;
    private final AlertReminderJobFactory alertReminderJobFactory;
    private final AlertCheckJobFactory alertCheckJobFactory;
    private final ReportService reportService;
    private final AuthorizedCollectionService authorizedCollectionService;
    private final AlertRecipientValidator alertRecipientValidator;
    private SchedulerFactoryBean schedulerFactoryBean;

    public AlertService(ApplicationContext applicationContext, AlertReader alertReader, AlertWriter alertWriter, ConfigurationService configurationService, AlertReminderJobFactory alertReminderJobFactory, AlertCheckJobFactory alertCheckJobFactory, ReportService reportService, AuthorizedCollectionService authorizedCollectionService, AlertRecipientValidator alertRecipientValidator) {
        this.applicationContext = applicationContext;
        this.alertReader = alertReader;
        this.alertWriter = alertWriter;
        this.configurationService = configurationService;
        this.alertReminderJobFactory = alertReminderJobFactory;
        this.alertCheckJobFactory = alertCheckJobFactory;
        this.reportService = reportService;
        this.authorizedCollectionService = authorizedCollectionService;
        this.alertRecipientValidator = alertRecipientValidator;
    }

    @PostConstruct
    public void init() {
        List<AlertDefinitionDto> alerts = this.alertReader.getStoredAlerts();
        try {
            if (this.schedulerFactoryBean == null) {
                SpringBeanJobFactory sampleJobFactory = new SpringBeanJobFactory();
                sampleJobFactory.setApplicationContext(this.applicationContext);
                this.schedulerFactoryBean = new SchedulerFactoryBean();
                this.schedulerFactoryBean.setOverwriteExistingJobs(true);
                this.schedulerFactoryBean.setJobFactory((JobFactory)sampleJobFactory);
                Map<AlertDefinitionDto, JobDetail> checkingDetails = this.createCheckDetails(alerts);
                List<Trigger> checkingTriggers = this.createCheckTriggers(checkingDetails);
                Map<AlertDefinitionDto, JobDetail> reminderDetails = this.createReminderDetails(alerts);
                List<Trigger> reminderTriggers = this.createReminderTriggers(reminderDetails);
                ArrayList<Trigger> allTriggers = new ArrayList<Trigger>();
                allTriggers.addAll(checkingTriggers);
                allTriggers.addAll(reminderTriggers);
                ArrayList<JobDetail> allJobDetails = new ArrayList<JobDetail>();
                allJobDetails.addAll(checkingDetails.values());
                allJobDetails.addAll(reminderDetails.values());
                JobDetail[] jobDetails = allJobDetails.toArray(new JobDetail[0]);
                Trigger[] triggers = allTriggers.toArray(new Trigger[0]);
                this.schedulerFactoryBean.setGlobalJobListeners(new JobListener[]{this.createReminderListener()});
                this.schedulerFactoryBean.setTriggers(triggers);
                this.schedulerFactoryBean.setJobDetails(jobDetails);
                this.schedulerFactoryBean.setApplicationContext(this.applicationContext);
                this.schedulerFactoryBean.setQuartzProperties(this.configurationService.getQuartzProperties());
                this.schedulerFactoryBean.afterPropertiesSet();
                this.schedulerFactoryBean.setWaitForJobsToCompleteOnShutdown(true);
                this.schedulerFactoryBean.start();
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't initialize alert scheduling.", (Throwable)e);
            try {
                this.destroy();
            }
            catch (Exception destroyException) {
                LOG.error("Failed destroying alertService", (Throwable)destroyException);
            }
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.schedulerFactoryBean != null) {
            try {
                this.schedulerFactoryBean.stop();
                this.schedulerFactoryBean.destroy();
            }
            catch (Exception e) {
                LOG.error("Can't destroy scheduler", (Throwable)e);
            }
            this.schedulerFactoryBean = null;
        }
    }

    public Scheduler getScheduler() {
        return this.schedulerFactoryBean.getObject();
    }

    public List<AlertDefinitionDto> getStoredAlertsForCollection(String userId, String collectionId) {
        List<String> authorizedReportIds = this.reportService.findAndFilterReports(userId, collectionId).stream().map(authorizedReportDefinitionDto -> authorizedReportDefinitionDto.getDefinitionDto().getId()).toList();
        return this.alertReader.getAlertsForReports(authorizedReportIds);
    }

    public JobDetail createStatusCheckJobDetails(AlertDefinitionDto fakeReportAlert) {
        return this.alertCheckJobFactory.createJobDetails(fakeReportAlert);
    }

    public Trigger createStatusCheckTrigger(AlertDefinitionDto fakeReportAlert, JobDetail jobDetail) {
        return this.alertCheckJobFactory.createTrigger(fakeReportAlert, jobDetail);
    }

    @Override
    public Set<ConflictedItemDto> getConflictedItemsForReportDelete(ReportDefinitionDto reportDefinition) {
        return this.mapAlertsToConflictingItems(this.getAlertsForReport(reportDefinition.getId()));
    }

    @Override
    public void handleReportDeleted(ReportDefinitionDto reportDefinition) {
        this.deleteAlertsForReport(reportDefinition.getId());
    }

    @Override
    public Set<ConflictedItemDto> getConflictedItemsForReportUpdate(ReportDefinitionDto currentDefinition, ReportDefinitionDto updateDefinition) {
        LinkedHashSet<ConflictedItemDto> conflictedItems = new LinkedHashSet<ConflictedItemDto>();
        if (currentDefinition instanceof SingleProcessReportDefinitionRequestDto) {
            if (this.validateIfReportIsSuitableForAlert((SingleProcessReportDefinitionRequestDto)currentDefinition) && !this.validateIfReportIsSuitableForAlert((SingleProcessReportDefinitionRequestDto)updateDefinition)) {
                conflictedItems.addAll(this.mapAlertsToConflictingItems(this.getAlertsForReport(currentDefinition.getId())));
            }
        } else if (currentDefinition instanceof SingleDecisionReportDefinitionRequestDto && this.validateIfReportIsSuitableForAlert((SingleDecisionReportDefinitionRequestDto)currentDefinition) && !this.validateIfReportIsSuitableForAlert((SingleDecisionReportDefinitionRequestDto)updateDefinition)) {
            conflictedItems.addAll(this.mapAlertsToConflictingItems(this.getAlertsForReport(currentDefinition.getId())));
        }
        return conflictedItems;
    }

    @Override
    public void handleReportUpdated(String reportId, ReportDefinitionDto updateDefinition) {
        this.deleteAlertsIfNeeded(reportId, updateDefinition);
    }

    private List<AlertDefinitionDto> getAlertsForReport(String reportId) {
        return this.alertReader.getAlertsForReport(reportId);
    }

    private AlertDefinitionDto getAlert(String alertId) {
        return this.alertReader.getAlert(alertId).orElseThrow(() -> new NotFoundException("Alert does not exist!"));
    }

    public IdResponseDto createAlert(AlertCreationRequestDto toCreate, String userId) {
        this.validateAlert(toCreate, userId);
        this.verifyUserAuthorizedToEditAlertOrFail(toCreate, userId);
        String alertId = this.createAlertForUser(toCreate, userId).getId();
        return new IdResponseDto(alertId);
    }

    public void copyAndMoveAlerts(String oldReportId, String newReportId) {
        List<AlertDefinitionDto> oldAlerts = this.getAlertsForReport(oldReportId);
        for (AlertDefinitionDto alert : oldAlerts) {
            alert.setReportId(newReportId);
            this.createAlert((AlertCreationRequestDto)alert, alert.getOwner());
        }
    }

    public void updateAlert(String alertId, AlertCreationRequestDto toCreate, String userId) {
        this.validateAlert(toCreate, userId);
        this.updateAlertForUser(alertId, toCreate, userId);
    }

    public void deleteAlert(String alertId, String userId) {
        this.verifyUserAuthorizedToEditAlertOrFail((AlertCreationRequestDto)this.getAlert(alertId), userId);
        AlertDefinitionDto toDelete = this.getAlert(alertId);
        this.alertWriter.deleteAlert(alertId);
        this.unscheduleJob(toDelete);
    }

    public void deleteAlerts(List<String> alertIds, String userId) {
        ArrayList<String> alertIdsToDelete = new ArrayList<String>();
        for (String alertId : alertIds) {
            try {
                this.verifyUserAuthorizedToEditAlertOrFail((AlertCreationRequestDto)this.getAlert(alertId), userId);
                alertIdsToDelete.add(alertId);
            }
            catch (NotFoundException e) {
                LOG.debug("Cannot find alert with id [{}], it may have been deleted already", (Object)alertId);
            }
        }
        this.alertWriter.deleteAlerts(alertIdsToDelete);
    }

    private void unscheduleJob(AlertDefinitionDto toDelete) {
        String alertId = toDelete.getId();
        try {
            this.unscheduleCheckJob(toDelete);
            this.unscheduleReminderJob(toDelete);
        }
        catch (SchedulerException e) {
            LOG.error("can't adjust scheduler for alert [{}]", (Object)alertId, (Object)e);
        }
        toDelete.setTriggered(false);
    }

    private static AlertDefinitionDto newAlert(AlertCreationRequestDto toCreate, String userId) {
        AlertDefinitionDto result = new AlertDefinitionDto();
        OffsetDateTime now = LocalDateUtil.getCurrentDateTime();
        result.setOwner(userId);
        result.setCreated(now);
        result.setLastModified(now);
        result.setLastModifier(userId);
        AlertUtil.mapBasicFields(toCreate, result);
        return result;
    }

    private void updateAlertForUser(String alertId, AlertCreationRequestDto toCreate, String userId) {
        this.verifyUserAuthorizedToEditAlertOrFail(toCreate, userId);
        AlertDefinitionDto toUpdate = this.getAlert(alertId);
        this.unscheduleJob(toUpdate);
        toUpdate.setLastModified(LocalDateUtil.getCurrentDateTime());
        toUpdate.setLastModifier(userId);
        AlertUtil.mapBasicFields(toCreate, toUpdate);
        this.alertWriter.updateAlert(toUpdate);
        this.scheduleAlert(toUpdate);
    }

    private void unscheduleReminderJob(AlertDefinitionDto toDelete) throws SchedulerException {
        JobKey toUnschedule = this.alertReminderJobFactory.getJobKey(toDelete);
        TriggerKey triggerKey = this.alertReminderJobFactory.getTriggerKey(toDelete);
        if (toUnschedule != null) {
            this.getScheduler().unscheduleJob(triggerKey);
            this.getScheduler().deleteJob(toUnschedule);
        }
    }

    private void unscheduleCheckJob(AlertDefinitionDto toDelete) throws SchedulerException {
        JobKey toUnschedule = this.alertCheckJobFactory.getJobKey(toDelete);
        TriggerKey triggerKey = this.alertReminderJobFactory.getTriggerKey(toDelete);
        if (toUnschedule != null) {
            this.getScheduler().unscheduleJob(triggerKey);
            this.getScheduler().deleteJob(toUnschedule);
        }
    }

    private void deleteAlertsForReport(String reportId) {
        this.alertReader.getAlertsForReport(reportId).forEach(this::unscheduleJob);
        this.alertWriter.deleteAlertsForReport(reportId);
    }

    private void deleteAlertsIfNeeded(String reportId, ReportDefinitionDto reportDefinition) {
        SingleProcessReportDefinitionRequestDto singleReport;
        if (reportDefinition instanceof SingleProcessReportDefinitionRequestDto && !this.validateIfReportIsSuitableForAlert(singleReport = (SingleProcessReportDefinitionRequestDto)reportDefinition)) {
            this.deleteAlertsForReport(reportId);
        }
    }

    private boolean validateIfReportIsSuitableForAlert(SingleProcessReportDefinitionRequestDto report) {
        ProcessReportDataDto data = (ProcessReportDataDto)report.getData();
        return data != null && data.getGroupBy() != null && ProcessGroupByType.NONE.equals((Object)data.getGroupBy().getType()) && ProcessVisualization.NUMBER.equals((Object)data.getVisualization()) && data.getView().getProperties().size() == 1 && data.getConfiguration().getAggregationTypes().size() == 1 && data.getConfiguration().getUserTaskDurationTimes().size() == 1;
    }

    private boolean validateIfReportIsSuitableForAlert(SingleDecisionReportDefinitionRequestDto report) {
        DecisionReportDataDto data = (DecisionReportDataDto)report.getData();
        return data != null && data.getGroupBy() != null && DecisionGroupByType.NONE.equals((Object)data.getGroupBy().getType()) && DecisionVisualization.NUMBER.equals((Object)data.getVisualization());
    }

    private Set<ConflictedItemDto> mapAlertsToConflictingItems(List<AlertDefinitionDto> alertsForReport) {
        return alertsForReport.stream().map(alertDto -> new ConflictedItemDto(alertDto.getId(), ConflictedItemType.ALERT, alertDto.getName())).collect(Collectors.toSet());
    }

    private void verifyUserAuthorizedToEditAlertOrFail(AlertCreationRequestDto alertDto, String userId) {
        AuthorizedReportDefinitionResponseDto reportDefinitionDto = this.reportService.getReportDefinition(alertDto.getReportId(), userId);
        this.authorizedCollectionService.verifyUserAuthorizedToEditCollectionResources(userId, reportDefinitionDto.getDefinitionDto().getCollectionId());
    }

    private void validateAlert(AlertCreationRequestDto toCreate, String userId) {
        ProcessReportDataDto data;
        ReportDefinitionDto report;
        try {
            report = this.reportService.getReportDefinition(toCreate.getReportId(), userId).getDefinitionDto();
        }
        catch (Exception e) {
            String errorMessage = "Could not create alert [" + toCreate.getName() + "]. Report id [" + toCreate.getReportId() + "] does not exist.";
            LOG.error(errorMessage);
            throw new BadRequestException(errorMessage, (Throwable)e);
        }
        if (report.getCollectionId() == null || report.getCollectionId().isEmpty()) {
            throw new BadRequestException("Alerts cannot be created for private reports, only for reports within a collection.");
        }
        ValidationHelper.ensureNotEmpty("Report", report);
        ValidationHelper.ensureNotEmpty("thresholdOperator", toCreate.getThresholdOperator());
        ValidationHelper.ensureNotNull("checkInterval", toCreate.getCheckInterval());
        ValidationHelper.ensureNotEmpty("unit", toCreate.getCheckInterval().getUnit());
        if (report.getData() instanceof ProcessReportDataDto && (data = (ProcessReportDataDto)report.getData()).getView() != null && data.getView().getFirstProperty() != null && data.getView().getFirstProperty().equals((Object)ViewProperty.PERCENTAGE) && (toCreate.getThreshold() == null || toCreate.getThreshold() > 100.0 || toCreate.getThreshold() < 0.0)) {
            throw new OptimizeValidationException("The threshold for alerts on % reports must be between 0 and 100.");
        }
        boolean emailsDefined = CollectionUtils.isNotEmpty((Collection)toCreate.getEmails());
        if (emailsDefined) {
            this.alertRecipientValidator.validateAlertRecipientEmailAddresses(toCreate.getEmails());
        }
        if (!emailsDefined) {
            throw new OptimizeValidationException("The field [emails] is not allowed to be empty.");
        }
    }

    private AlertDefinitionDto createAlertForUser(AlertCreationRequestDto toCreate, String userId) {
        AlertDefinitionDto alert = this.alertWriter.createAlert(AlertService.newAlert(toCreate, userId));
        this.scheduleAlert(alert);
        return alert;
    }

    private void scheduleAlert(AlertDefinitionDto alert) {
        try {
            JobDetail jobDetail = this.alertCheckJobFactory.createJobDetails(alert);
            if (this.schedulerFactoryBean != null) {
                this.getScheduler().scheduleJob(jobDetail, this.alertCheckJobFactory.createTrigger(alert, jobDetail));
            }
        }
        catch (SchedulerException e) {
            LOG.error("can't schedule new alert", (Throwable)e);
        }
    }

    private List<Trigger> createReminderTriggers(Map<AlertDefinitionDto, JobDetail> reminderDetails) {
        return reminderDetails.entrySet().stream().filter(entry -> Objects.nonNull(((AlertDefinitionDto)entry.getKey()).getReminder())).map(entry -> this.alertReminderJobFactory.createTrigger((AlertDefinitionDto)entry.getKey(), (JobDetail)entry.getValue())).collect(Collectors.toList());
    }

    private List<Trigger> createCheckTriggers(Map<AlertDefinitionDto, JobDetail> details) {
        return details.entrySet().stream().map(entry -> this.alertCheckJobFactory.createTrigger((AlertDefinitionDto)entry.getKey(), (JobDetail)entry.getValue())).collect(Collectors.toList());
    }

    private Map<AlertDefinitionDto, JobDetail> createReminderDetails(List<AlertDefinitionDto> alerts) {
        return alerts.stream().collect(Collectors.toMap(alert -> alert, this.alertReminderJobFactory::createJobDetails));
    }

    private Map<AlertDefinitionDto, JobDetail> createCheckDetails(List<AlertDefinitionDto> alerts) {
        return alerts.stream().collect(Collectors.toMap(alert -> alert, this.alertCheckJobFactory::createJobDetails));
    }

    private JobListener createReminderListener() {
        return new ReminderHandlingListener(this.alertReminderJobFactory);
    }
}

