/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestResponseDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewResponseDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOwnerResponseDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessUpdateDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.KpiService;
import io.camunda.optimize.service.db.reader.ProcessOverviewReader;
import io.camunda.optimize.service.db.writer.ProcessOverviewWriter;
import io.camunda.optimize.service.digest.DigestService;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessOverviewService {
    private static final String PENDING_OWNER_UPDATE_TEMPLATE = "pendingauthcheck#%s#%s";
    private static final Logger LOG = LoggerFactory.getLogger(ProcessOverviewService.class);
    private final DefinitionService definitionService;
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService;
    private final ProcessOverviewWriter processOverviewWriter;
    private final ProcessOverviewReader processOverviewReader;
    private final AbstractIdentityService identityService;
    private final KpiService kpiService;
    private final DigestService digestService;

    public ProcessOverviewService(DefinitionService definitionService, DataSourceDefinitionAuthorizationService definitionAuthorizationService, ProcessOverviewWriter processOverviewWriter, ProcessOverviewReader processOverviewReader, AbstractIdentityService identityService, KpiService kpiService, DigestService digestService) {
        this.definitionService = definitionService;
        this.definitionAuthorizationService = definitionAuthorizationService;
        this.processOverviewWriter = processOverviewWriter;
        this.processOverviewReader = processOverviewReader;
        this.identityService = identityService;
        this.kpiService = kpiService;
        this.digestService = digestService;
    }

    public List<ProcessOverviewResponseDto> getAllProcessOverviews(String userId, String locale) {
        Map<String, String> procDefKeysAndName = this.definitionService.getAllDefinitionsWithTenants(DefinitionType.PROCESS).stream().filter(def -> this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, DefinitionType.PROCESS, def.getKey(), def.getTenantIds())).peek(def -> this.definitionService.getCachedTenantToLatestDefinitionMap(DefinitionType.PROCESS, def.getKey()).values().stream().max(Comparator.comparing(DefinitionOptimizeResponseDto::getVersion)).ifPresent(latestVersionOfDef -> {
            if (!StringUtils.isEmpty((CharSequence)latestVersionOfDef.getName())) {
                def.setName(latestVersionOfDef.getName());
            } else {
                def.setName(def.getKey());
            }
        })).collect(Collectors.toMap(SimpleDefinitionDto::getKey, SimpleDefinitionDto::getName));
        Map<String, ProcessOverviewDto> processOverviewByKey = this.processOverviewReader.getProcessOverviewsByKey(procDefKeysAndName.keySet());
        return procDefKeysAndName.entrySet().stream().map(entry -> {
            String procDefKey = (String)entry.getKey();
            Optional<ProcessOverviewDto> overviewForKey = Optional.ofNullable((ProcessOverviewDto)processOverviewByKey.get(procDefKey));
            return new ProcessOverviewResponseDto((String)entry.getValue(), procDefKey, overviewForKey.flatMap(overview -> Optional.ofNullable(overview.getOwner()).map(owner -> new ProcessOwnerResponseDto(owner, this.identityService.getIdentityNameById((String)owner).orElse((String)owner)))).orElse(new ProcessOwnerResponseDto()), (ProcessDigestResponseDto)overviewForKey.map(ProcessOverviewDto::getDigest).orElse(new ProcessDigestDto(Boolean.valueOf(false), new HashMap())), overviewForKey.map(processOverviewDto -> this.kpiService.extractMostRecentKpiResultsForCurrentKpiReportsForProcess((ProcessOverviewDto)processOverviewDto, locale)).orElse(Collections.emptyList()));
        }).collect(Collectors.toList());
    }

    public void updateProcess(String userId, String processDefKey, ProcessUpdateDto processUpdateDto) {
        this.validateProcessDefinitionAuthorization(userId, processDefKey);
        String ownerIdToSave = this.getValidatedOwnerId(userId, processUpdateDto.getOwnerId());
        processUpdateDto.setOwnerId(ownerIdToSave);
        if (processUpdateDto.getProcessDigest().isEnabled() && processUpdateDto.getOwnerId() == null) {
            throw new BadRequestException("Process digest cannot be enabled if no owner is set");
        }
        this.processOverviewWriter.updateProcessConfiguration(processDefKey, processUpdateDto);
        this.digestService.handleProcessUpdate(processDefKey, processUpdateDto);
    }

    public void updateProcessOwnerIfNotSet(String userId, String processDefinitionKey, String ownerId) {
        String ownerIdToSave = this.getValidatedOwnerId(userId, ownerId);
        if (ownerIdToSave == null || ownerIdToSave.isEmpty()) {
            throw new BadRequestException("Owner ID cannot be empty!");
        }
        if (this.definitionHasBeenImported(processDefinitionKey)) {
            LOG.info("Updating owner of process " + processDefinitionKey + " to " + ownerIdToSave);
            this.validateProcessDefinitionAuthorization(userId, processDefinitionKey);
            this.processOverviewWriter.updateProcessOwnerIfNotSet(processDefinitionKey, ownerIdToSave);
        } else {
            LOG.info(String.format("Process definition %s has not been imported to optimize yet, so saving the prospective owner %s as pending", processDefinitionKey, ownerIdToSave));
            String pendingProcessKey = String.format(PENDING_OWNER_UPDATE_TEMPLATE, userId, processDefinitionKey);
            this.processOverviewWriter.updateProcessOwnerIfNotSet(pendingProcessKey, ownerIdToSave);
        }
    }

    private String getValidatedOwnerId(String userId, String ownerId) {
        return Optional.ofNullable(ownerId).map(owner -> {
            Optional<String> ownerUserId = this.identityService.getUserById((String)owner).map(IdentityDto::getId);
            if (ownerUserId.isEmpty() || !userId.equals(ownerUserId.get()) && !this.identityService.isUserAuthorizedToAccessIdentity(userId, new IdentityDto(ownerId, IdentityType.USER))) {
                throw new ForbiddenException(String.format("Could not find a user with ID %s that the user %s is authorized to see.", owner, userId));
            }
            return ownerUserId.get();
        }).orElse(null);
    }

    private boolean definitionHasBeenImported(String processDefinitionKey) {
        try {
            return this.definitionService.getLatestVersionToKey(DefinitionType.PROCESS, processDefinitionKey) != null;
        }
        catch (NotFoundException exception) {
            LOG.info("Process with definition key {} has not yet been imported", (Object)processDefinitionKey);
            return false;
        }
    }

    public void confirmOrDenyOwnershipData(String processToBeOnboarded) {
        Map<String, ProcessOverviewDto> pendingProcesses = this.processOverviewReader.getProcessOverviewsWithPendingOwnershipData();
        pendingProcesses.keySet().stream().filter(completeDefKey -> {
            Pattern pattern = Pattern.compile(String.format(PENDING_OWNER_UPDATE_TEMPLATE, "(.*)", processToBeOnboarded + "$"));
            return pattern.matcher((CharSequence)completeDefKey).matches();
        }).forEach(completeDefKey -> {
            String userIdFromRequester = this.extractUserIdFromPendingDefKey((String)completeDefKey).orElse(null);
            String ownerId = ((ProcessOverviewDto)pendingProcesses.get(completeDefKey)).getOwner();
            try {
                this.updateProcessOwnerIfNotSet(userIdFromRequester, processToBeOnboarded, ownerId);
                this.processOverviewWriter.deleteProcessOwnerEntry((String)completeDefKey);
            }
            catch (Exception exc) {
                LOG.warn(exc.getMessage(), (Throwable)exc);
            }
        });
    }

    private Optional<String> extractUserIdFromPendingDefKey(String defKey) {
        Pattern pattern = Pattern.compile(String.format(PENDING_OWNER_UPDATE_TEMPLATE, "(.*)", "(.*)$"));
        Matcher matcher = pattern.matcher(defKey);
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private void validateProcessDefinitionAuthorization(String userId, String processDefKey) {
        this.definitionService.getProcessDefinitionWithTenants(processDefKey).ifPresentOrElse(definition -> {
            if (!this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, DefinitionType.PROCESS, definition.getKey(), definition.getTenantIds())) {
                throw new ForbiddenException("User is not authorized to access the process definition with key " + processDefKey);
            }
        }, () -> {
            throw new NotFoundException("Process definition with key " + processDefKey + " does not exist.");
        });
    }
}

