/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.analysis.DurationChartEntryDto;
import io.camunda.optimize.dto.optimize.query.analysis.FindingsDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierVariableParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.OutlierAnalysisServiceParameters;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessDefinitionParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessInstanceIdDto;
import io.camunda.optimize.dto.optimize.query.analysis.VariableTermDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.db.reader.DurationOutliersReader;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class OutlierAnalysisService {
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService;
    private final DurationOutliersReader outliersReader;

    public OutlierAnalysisService(DataSourceDefinitionAuthorizationService definitionAuthorizationService, DurationOutliersReader outliersReader) {
        this.definitionAuthorizationService = definitionAuthorizationService;
        this.outliersReader = outliersReader;
    }

    public Map<String, FindingsDto> getFlowNodeOutlierMap(OutlierAnalysisServiceParameters<ProcessDefinitionParametersDto> outlierAnalysisParams) {
        this.doAuthorizationCheck(outlierAnalysisParams);
        return this.outliersReader.getFlowNodeOutlierMap(outlierAnalysisParams);
    }

    public List<DurationChartEntryDto> getCountByDurationChart(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierAnalysisParams) {
        this.doAuthorizationCheck(outlierAnalysisParams);
        return this.outliersReader.getCountByDurationChart(outlierAnalysisParams);
    }

    public List<VariableTermDto> getSignificantOutlierVariableTerms(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierAnalysisParams) {
        this.doAuthorizationCheck(outlierAnalysisParams);
        return this.outliersReader.getSignificantOutlierVariableTerms(outlierAnalysisParams);
    }

    public List<ProcessInstanceIdDto> getSignificantOutlierVariableTermsInstanceIds(OutlierAnalysisServiceParameters<FlowNodeOutlierVariableParametersDto> outlierAnalysisParams) {
        this.doAuthorizationCheck(outlierAnalysisParams);
        return this.outliersReader.getSignificantOutlierVariableTermsInstanceIds(outlierAnalysisParams);
    }

    private <T extends ProcessDefinitionParametersDto> void doAuthorizationCheck(OutlierAnalysisServiceParameters<T> outlierAnalysisParams) {
        if (!this.definitionAuthorizationService.isAuthorizedToAccessDefinition(outlierAnalysisParams.getUserId(), DefinitionType.PROCESS, ((ProcessDefinitionParametersDto)outlierAnalysisParams.getProcessDefinitionParametersDto()).getProcessDefinitionKey(), ((ProcessDefinitionParametersDto)outlierAnalysisParams.getProcessDefinitionParametersDto()).getTenantIds())) {
            throw new ForbiddenException("Current user is not authorized to access data of the provided process definition and tenant combination");
        }
    }
}

