/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.dto.optimize.importing.LastKpiEvaluationResultsDto;
import io.camunda.optimize.dto.optimize.query.processoverview.KpiResultDto;
import io.camunda.optimize.service.AbstractScheduledService;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.KpiService;
import io.camunda.optimize.service.db.writer.ProcessOverviewWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.stereotype.Component;

@Component
public class KpiEvaluationSchedulerService
extends AbstractScheduledService {
    private static final Logger LOG = LoggerFactory.getLogger(KpiEvaluationSchedulerService.class);
    private final ProcessOverviewWriter processOverviewWriter;
    private final DefinitionService definitionService;
    private final ConfigurationService configurationService;
    private final KpiService kpiService;

    public KpiEvaluationSchedulerService(ProcessOverviewWriter processOverviewWriter, DefinitionService definitionService, ConfigurationService configurationService, KpiService kpiService) {
        this.processOverviewWriter = processOverviewWriter;
        this.definitionService = definitionService;
        this.configurationService = configurationService;
        this.kpiService = kpiService;
    }

    @PostConstruct
    public void init() {
        this.startScheduling();
    }

    @PreDestroy
    public synchronized void stopCleanupScheduling() {
        LOG.info("Stopping KPI evaluation scheduler");
        this.stopScheduling();
    }

    public void runKpiImportTask() {
        this.run();
    }

    @Override
    protected void run() {
        LOG.debug("Scheduling KPI evaluation tasks for all existing processes.");
        List processDefinitionKeys = this.definitionService.getAllDefinitionsWithTenants(DefinitionType.PROCESS).stream().map(SimpleDefinitionDto::getKey).collect(Collectors.toList());
        HashMap<String, LastKpiEvaluationResultsDto> definitionKeyToKpis = new HashMap<String, LastKpiEvaluationResultsDto>();
        for (String processDefinitionKey : processDefinitionKeys) {
            HashMap<String, String> reportIdToKpiValue = new HashMap<String, String>();
            List<KpiResultDto> kpiResultDtos = this.kpiService.evaluateKpiReports(processDefinitionKey);
            for (KpiResultDto kpi : kpiResultDtos) {
                reportIdToKpiValue.put(kpi.getReportId(), kpi.getValue());
            }
            LastKpiEvaluationResultsDto lastKpiEvaluationResultsDto = new LastKpiEvaluationResultsDto(reportIdToKpiValue);
            definitionKeyToKpis.put(processDefinitionKey, lastKpiEvaluationResultsDto);
        }
        this.processOverviewWriter.updateKpisForProcessDefinitions(definitionKeyToKpis);
    }

    @Override
    protected Trigger createScheduleTrigger() {
        return new PeriodicTrigger(Duration.ofSeconds(this.configurationService.getEntityConfiguration().getKpiRefreshInterval()));
    }

    @Override
    public synchronized boolean startScheduling() {
        LOG.info("Scheduling KPI evaluation scheduler.");
        return super.startScheduling();
    }
}

