/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.license.CamundaLicense;
import io.camunda.optimize.license.LicenseType;
import java.time.OffsetDateTime;
import org.springframework.stereotype.Component;

@Component
public class CamundaLicenseService {
    private final CamundaLicense license;

    public CamundaLicenseService() {
        String camundaLicense = System.getenv("CAMUNDA_LICENSE_KEY");
        this.license = new CamundaLicense(camundaLicense);
    }

    public boolean isCamundaLicenseValid() {
        return this.license.isValid();
    }

    public LicenseType getCamundaLicenseType() {
        return this.license.getLicenseType();
    }

    public boolean isCommercialCamundaLicense() {
        return this.license.isCommercial();
    }

    public OffsetDateTime getCamundaLicenseExpiresAt() {
        return this.license.expiresAt();
    }
}

