/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import java.util.concurrent.ScheduledFuture;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public abstract class AbstractScheduledService {
    protected ThreadPoolTaskScheduler taskScheduler;
    private ScheduledFuture<?> scheduledTrigger;

    public synchronized boolean isScheduledToRun() {
        return this.scheduledTrigger != null;
    }

    protected String getName() {
        return this.getClass().getSimpleName() + "-";
    }

    protected abstract void run();

    protected abstract Trigger createScheduleTrigger();

    protected synchronized boolean startScheduling() {
        boolean wasScheduled = false;
        if (this.taskScheduler == null) {
            this.taskScheduler = new ThreadPoolTaskScheduler();
            this.taskScheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.taskScheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.taskScheduler.setThreadNamePrefix(this.getName());
            this.taskScheduler.initialize();
            wasScheduled = true;
        }
        if (this.scheduledTrigger == null) {
            this.scheduledTrigger = this.taskScheduler.schedule(this::run, this.createScheduleTrigger());
        }
        return wasScheduled;
    }

    protected synchronized void stopScheduling() {
        if (this.scheduledTrigger != null) {
            this.scheduledTrigger.cancel(true);
            this.scheduledTrigger = null;
        }
        if (this.taskScheduler != null) {
            this.taskScheduler.destroy();
            this.taskScheduler = null;
        }
    }
}

