/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.providers;

import io.camunda.optimize.dto.optimize.rest.ErrorResponseDto;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.exceptions.evaluation.ReportEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@Order(value=-2147483648)
public class ReportEvaluationExceptionMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ReportEvaluationExceptionMapper.class);
    @Autowired
    private LocalizationService localizationService;

    @ExceptionHandler(value={ReportEvaluationException.class})
    public ResponseEntity<ErrorResponseDto> handleReportEvaluationException(ReportEvaluationException reportEvaluationException) {
        LOG.info("Mapping ReportEvaluationException");
        ErrorResponseDto errorResponseDto = this.getErrorResponseDto(reportEvaluationException);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponseDto);
    }

    private ErrorResponseDto getErrorResponseDto(ReportEvaluationException exception) {
        String errorCode = exception.getErrorCode();
        String errorMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        String detailedErrorMessage = exception.getMessage();
        return new ErrorResponseDto(errorCode, errorMessage, detailedErrorMessage, exception.getReportDefinition());
    }
}

