/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import io.camunda.optimize.service.util.configuration.security.CloudAuthConfiguration;
import io.camunda.optimize.service.util.configuration.users.CloudUsersConfiguration;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public abstract class AbstractCCSaaSClient {
    protected static final String GET_ORGS_TEMPLATE = "%s/external/organizations/%s";
    protected final CloseableHttpClient httpClient;
    protected final ObjectMapper objectMapper;
    protected final ConfigurationService configurationService;

    protected AbstractCCSaaSClient(ObjectMapper objectMapper, ConfigurationService configurationService) {
        this.objectMapper = objectMapper;
        this.configurationService = configurationService;
        HttpClientBuilder builder = HttpClientBuilder.create();
        int timeout = 5000;
        builder.setConnectionTimeToLive(5000L, TimeUnit.MILLISECONDS);
        builder.evictIdleConnections(5000L, TimeUnit.MILLISECONDS);
        RequestConfig rc = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build();
        builder.setDefaultRequestConfig(rc);
        this.httpClient = builder.build();
    }

    public CloseableHttpResponse performRequest(HttpRequestBase request, String accessToken) throws IOException {
        request.setHeader("Authorization", "Bearer " + accessToken);
        return this.httpClient.execute((HttpUriRequest)request);
    }

    protected CloseableHttpResponse performRequest(HttpRequestBase request) throws IOException {
        return this.httpClient.execute((HttpUriRequest)request);
    }

    protected CloudUsersConfiguration getCloudUsersConfiguration() {
        return this.configurationService.getUsersConfiguration().getCloud();
    }

    protected CloudAuthConfiguration getCloudAuthConfiguration() {
        return this.configurationService.getAuthConfiguration().getCloudAuthConfiguration();
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.httpClient.close();
    }
}

