/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.actuator;

import io.camunda.optimize.dto.optimize.rest.BackupInfoDto;
import io.camunda.optimize.dto.optimize.rest.BackupRequestDto;
import io.camunda.optimize.dto.optimize.rest.ErrorResponseDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.BackupService;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import io.camunda.optimize.service.exceptions.OptimizeElasticsearchConnectionException;
import io.camunda.optimize.service.exceptions.OptimizeOpenSearchConnectionException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeConflictException;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.xml.bind.ValidationException;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Component
@RestControllerEndpoint(id="backups")
public class BackupRestService {
    private final BackupService backupService;
    private final LocalizationService localizationService;

    public BackupRestService(BackupService backupService, LocalizationService localizationService) {
        this.backupService = backupService;
        this.localizationService = localizationService;
    }

    @PostMapping(produces={"application/json"})
    public ResponseEntity<String> takeBackup(@RequestBody @Valid BackupRequestDto backupRequestDto) {
        this.backupService.triggerBackup(backupRequestDto.getBackupId());
        return new ResponseEntity((Object)String.format("{\"message\" : \"Backup creation for ID %d has been scheduled. Use the GET API to monitor completion of backup process\"}", backupRequestDto.getBackupId()), (HttpStatusCode)HttpStatus.ACCEPTED);
    }

    @GetMapping(value={"/{backupId}"})
    public BackupInfoDto info(@PathVariable(value="backupId") @Nullable Long backupId) {
        return this.backupService.getSingleBackupInfo(backupId);
    }

    @GetMapping
    public List<BackupInfoDto> info() {
        return this.backupService.getAllBackupInfo();
    }

    @DeleteMapping(value={"/{backupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable(value="backupId") Long backupId) {
        this.backupService.deleteBackup(backupId);
    }

    @ExceptionHandler(value={OptimizeRuntimeException.class})
    public ResponseEntity<ErrorResponseDto> handleServerException(OptimizeRuntimeException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)this.getErrorResponseDto((Throwable)exception));
    }

    @ExceptionHandler(value={OptimizeConfigurationException.class})
    public ResponseEntity<ErrorResponseDto> handleConfigurationException(OptimizeConfigurationException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)this.getErrorResponseDto((Throwable)exception));
    }

    @ExceptionHandler(value={OptimizeConflictException.class})
    public ResponseEntity<ErrorResponseDto> handleConflictException(OptimizeConflictException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).contentType(MediaType.APPLICATION_JSON).body((Object)this.getErrorResponseDto((Throwable)((Object)exception)));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ErrorResponseDto> handleValidationException(MethodArgumentNotValidException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponseDto("badRequestError", this.localizationService.getDefaultLocaleMessageForApiErrorCode("badRequestError"), Optional.ofNullable(exception.getFieldError()).map(DefaultMessageSourceResolvable::getDefaultMessage).orElse(exception.getMessage())));
    }

    @ExceptionHandler(value={BadRequestException.class})
    public ResponseEntity<ErrorResponseDto> handleBadRequestException(BadRequestException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)this.getErrorResponseDto((Throwable)exception));
    }

    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<ErrorResponseDto> handleNotFoundException(NotFoundException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_JSON).body((Object)this.getErrorResponseDto((Throwable)exception));
    }

    @ExceptionHandler(value={OptimizeElasticsearchConnectionException.class})
    public ResponseEntity<ErrorResponseDto> handleElasticsearchConnectionException(OptimizeElasticsearchConnectionException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_GATEWAY).contentType(MediaType.APPLICATION_JSON).body((Object)this.getErrorResponseDto((Throwable)((Object)exception)));
    }

    @ExceptionHandler(value={OptimizeOpenSearchConnectionException.class})
    public ResponseEntity<ErrorResponseDto> handleOptimizeOpenSearchConnectionException(OptimizeOpenSearchConnectionException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_GATEWAY).contentType(MediaType.APPLICATION_JSON).body((Object)this.getErrorResponseDto((Throwable)((Object)exception)));
    }

    private ErrorResponseDto getErrorResponseDto(Throwable e) {
        Class<?> errorClass = e.getClass();
        String errorCode = NotFoundException.class.equals(errorClass) ? "notFoundError" : (BadRequestException.class.equals(errorClass) || ValidationException.class.equals(errorClass) ? "badRequestError" : (OptimizeConflictException.class.equals(errorClass) ? "conflict" : (OptimizeElasticsearchConnectionException.class.equals(errorClass) ? "elasticsearchConnectionError" : (OptimizeOpenSearchConnectionException.class.equals(errorClass) ? "openSearchConnectionError" : "serverError"))));
        String localizedMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        return new ErrorResponseDto(errorCode, localizedMessage, e.getMessage());
    }
}

