/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.report.AdditionalProcessReportEvaluationFilterDto;
import io.camunda.optimize.dto.optimize.query.sharing.DashboardShareRestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ReportShareRestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ShareSearchRequestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ShareSearchResultResponseDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationRequestDto;
import io.camunda.optimize.dto.optimize.rest.report.AuthorizedReportEvaluationResponseDto;
import io.camunda.optimize.rest.mapper.DashboardRestMapper;
import io.camunda.optimize.rest.mapper.ReportRestMapper;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.SettingsService;
import io.camunda.optimize.service.exceptions.SharingNotAllowedException;
import io.camunda.optimize.service.mixpanel.EventReportingService;
import io.camunda.optimize.service.mixpanel.client.EventReportingEvent;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.security.SharingService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.OptimizeProfile;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.time.ZoneId;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/share"})
public class SharingRestService {
    public static final String SHARE_PATH = "/share";
    public static final String REPORT_SUB_PATH = "/report";
    public static final String DASHBOARD_SUB_PATH = "/dashboard";
    public static final String EVALUATE_SUB_PATH = "/evaluate";
    private final SharingService sharingService;
    private final SettingsService settingsService;
    private final SessionService sessionService;
    private final ReportRestMapper reportRestMapper;
    private final DashboardRestMapper dashboardRestMapper;
    private final EventReportingService eventReportingService;
    private final Environment environment;

    public SharingRestService(SharingService sharingService, SettingsService settingsService, SessionService sessionService, ReportRestMapper reportRestMapper, DashboardRestMapper dashboardRestMapper, EventReportingService eventReportingService, Environment environment) {
        this.sharingService = sharingService;
        this.settingsService = settingsService;
        this.sessionService = sessionService;
        this.reportRestMapper = reportRestMapper;
        this.dashboardRestMapper = dashboardRestMapper;
        this.eventReportingService = eventReportingService;
        this.environment = environment;
    }

    @PostMapping(value={"/report"})
    public IdResponseDto createNewReportShare(@RequestBody ReportShareRestDto createSharingDto, HttpServletRequest request) {
        return this.executeIfSharingEnabled(() -> this.sharingService.createNewReportShareIfAbsent(createSharingDto, this.sessionService.getRequestUserOrFailNotAuthorized(request)), EventReportingEvent.REPORT_SHARE_ENABLED, "Sharing of reports is disabled per Optimize configuration");
    }

    @PostMapping(value={"/dashboard"})
    public IdResponseDto createNewDashboardShare(@RequestBody DashboardShareRestDto createSharingDto, HttpServletRequest request) {
        return this.executeIfSharingEnabled(() -> this.sharingService.createNewDashboardShare(createSharingDto, this.sessionService.getRequestUserOrFailNotAuthorized(request)), EventReportingEvent.DASHBOARD_SHARE_ENABLED, "Sharing of dashboards is disabled per Optimize configuration");
    }

    @DeleteMapping(value={"/report/{shareId}"})
    public void deleteReportShare(@PathVariable(value="shareId") String reportShareId) {
        this.sharingService.deleteReportShare(reportShareId);
        this.eventReportingService.sendEntityEvent(EventReportingEvent.REPORT_SHARE_DISABLED, reportShareId);
    }

    @DeleteMapping(value={"/dashboard/{shareId}"})
    public void deleteDashboardShare(@PathVariable(value="shareId") String dashboardShareId) {
        this.sharingService.deleteDashboardShare(dashboardShareId);
        this.eventReportingService.sendEntityEvent(EventReportingEvent.DASHBOARD_SHARE_DISABLED, dashboardShareId);
    }

    @GetMapping(value={"/report/{reportId}"})
    public ResponseEntity<ReportShareRestDto> findShareForReport(@PathVariable(value="reportId") String reportId) {
        Optional<ReportShareRestDto> result = this.sharingService.findShareForReport(reportId);
        if (result.isPresent()) {
            return ResponseEntity.ok((Object)result.get());
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/dashboard/{dashboardId}"})
    public ResponseEntity<DashboardShareRestDto> findShareForDashboard(@PathVariable(value="dashboardId") String dashboardId) {
        Optional<DashboardShareRestDto> result = this.sharingService.findShareForDashboard(dashboardId);
        if (result.isPresent()) {
            return ResponseEntity.ok((Object)result.get());
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/report/{shareId}/evaluate"})
    public AuthorizedReportEvaluationResponseDto evaluateReport(@PathVariable(value="shareId") String reportShareId, @Valid @RequestBody PaginationRequestDto paginationRequestDto, HttpServletRequest request) {
        ZoneId timezone = TimeZoneUtil.extractTimezone(request);
        return this.reportRestMapper.mapToLocalizedEvaluationResponseDto(this.sharingService.evaluateReportShare(reportShareId, timezone, PaginationDto.fromPaginationRequest((PaginationRequestDto)paginationRequestDto)), request.getHeader("X-Optimize-Client-Locale"), ConfigurationService.getOptimizeProfile((Environment)this.environment) == OptimizeProfile.CLOUD);
    }

    @PostMapping(value={"/dashboard/{shareId}/report/{reportId}/evaluate"})
    public AuthorizedReportEvaluationResponseDto evaluateReport(@PathVariable(value="shareId") String dashboardShareId, @PathVariable(value="reportId") String reportId, @RequestBody AdditionalProcessReportEvaluationFilterDto reportEvaluationFilter, @Valid PaginationRequestDto paginationRequestDto, HttpServletRequest request) {
        ZoneId timezone = TimeZoneUtil.extractTimezone(request);
        return this.reportRestMapper.mapToLocalizedEvaluationResponseDto(this.sharingService.evaluateReportForSharedDashboard(dashboardShareId, reportId, timezone, reportEvaluationFilter, PaginationDto.fromPaginationRequest((PaginationRequestDto)paginationRequestDto)), request.getHeader("X-Optimize-Client-Locale"), ConfigurationService.getOptimizeProfile((Environment)this.environment) == OptimizeProfile.CLOUD);
    }

    @GetMapping(value={"/dashboard/{shareId}/evaluate"})
    public DashboardDefinitionRestDto evaluateDashboard(@PathVariable(value="shareId") String dashboardShareId, HttpServletRequest request) {
        DashboardDefinitionRestDto dashboardDefinitionDto = this.sharingService.evaluateDashboard(dashboardShareId).orElse(null);
        this.dashboardRestMapper.prepareRestResponse(dashboardDefinitionDto, request.getHeader("X-Optimize-Client-Locale"), ConfigurationService.getOptimizeProfile((Environment)this.environment) == OptimizeProfile.CLOUD);
        return dashboardDefinitionDto;
    }

    @GetMapping(value={"/dashboard/{dashboardId}/isAuthorizedToShare"})
    public String isAuthorizedToShareDashboard(@PathVariable(value="dashboardId") String dashboardId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.sharingService.validateAndCheckAuthorization(dashboardId, userId);
        return "OK";
    }

    @PostMapping(value={"/status"})
    public ShareSearchResultResponseDto checkShareStatus(@RequestBody ShareSearchRequestDto searchRequest) {
        return this.sharingService.checkShareStatus(searchRequest);
    }

    private IdResponseDto executeIfSharingEnabled(Supplier<IdResponseDto> supplier, EventReportingEvent eventName, String sharingDisabledMessage) {
        return this.settingsService.getSettings().getSharingEnabled().filter(Boolean::booleanValue).map(isEnabled -> {
            IdResponseDto responseDto = (IdResponseDto)supplier.get();
            this.eventReportingService.sendEntityEvent(eventName, responseDto.getId());
            return responseDto;
        }).orElseThrow(() -> new SharingNotAllowedException(sharingDisabledMessage));
    }
}

