/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.GroupDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.report.AdditionalProcessReportEvaluationFilterDto;
import io.camunda.optimize.dto.optimize.query.ui_configuration.UIConfigurationResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.rest.FlowNodeIdsToNamesRequestDto;
import io.camunda.optimize.dto.optimize.rest.FlowNodeNamesResponseDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationRequestDto;
import io.camunda.optimize.dto.optimize.rest.report.AuthorizedReportEvaluationResponseDto;
import io.camunda.optimize.rest.AssigneeRestService;
import io.camunda.optimize.rest.CandidateGroupRestService;
import io.camunda.optimize.rest.DecisionVariablesRestService;
import io.camunda.optimize.rest.FlowNodeRestService;
import io.camunda.optimize.rest.LocalizationRestService;
import io.camunda.optimize.rest.ProcessVariableRestService;
import io.camunda.optimize.rest.SharingRestService;
import io.camunda.optimize.rest.UIConfigurationRestService;
import io.camunda.optimize.rest.exceptions.NotAuthorizedException;
import io.camunda.optimize.rest.providers.CacheRequest;
import io.camunda.optimize.service.SettingsService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/external"})
public class SharingPublicReaderRestService {
    private static final String SHARING_DISABLED_MSG = "Sharing has been disabled by configuration";
    private final SharingRestService protectedSharingRestService;
    private final LocalizationRestService localizationRestService;
    private final ProcessVariableRestService processVariableRestService;
    private final DecisionVariablesRestService decisionVariableRestService;
    private final FlowNodeRestService flowNodeRestService;
    private final CandidateGroupRestService candidateGroupRestService;
    private final UIConfigurationRestService uiConfigurationService;
    private final AssigneeRestService assigneeRestService;
    private final SettingsService settingsService;

    public SharingPublicReaderRestService(SharingRestService protectedSharingRestService, LocalizationRestService localizationRestService, ProcessVariableRestService processVariableRestService, DecisionVariablesRestService decisionVariableRestService, FlowNodeRestService flowNodeRestService, CandidateGroupRestService candidateGroupRestService, UIConfigurationRestService uiConfigurationService, AssigneeRestService assigneeRestService, SettingsService settingsService) {
        this.protectedSharingRestService = protectedSharingRestService;
        this.localizationRestService = localizationRestService;
        this.processVariableRestService = processVariableRestService;
        this.decisionVariableRestService = decisionVariableRestService;
        this.flowNodeRestService = flowNodeRestService;
        this.candidateGroupRestService = candidateGroupRestService;
        this.uiConfigurationService = uiConfigurationService;
        this.assigneeRestService = assigneeRestService;
        this.settingsService = settingsService;
    }

    @GetMapping(value={"/ui-configuration"})
    public UIConfigurationResponseDto getUIConfiguration() {
        return this.uiConfigurationService.getUIConfiguration();
    }

    @GetMapping(value={"/localization"})
    @CacheRequest
    public byte[] getLocalizationFile(@RequestParam(name="localeCode", required=false) String localeCode) {
        return this.localizationRestService.getLocalizationFile(localeCode);
    }

    @PostMapping(value={"/share/report/{shareId}/evaluate"})
    public AuthorizedReportEvaluationResponseDto evaluateReport(@PathVariable(value="shareId") String reportShareId, @Valid PaginationRequestDto paginationRequestDto, HttpServletRequest request) {
        return this.executeIfSharingEnabled(() -> this.protectedSharingRestService.evaluateReport(reportShareId, paginationRequestDto, request));
    }

    @PostMapping(value={"/share/dashboard/{shareId}/report/{reportId}/evaluate"})
    public AuthorizedReportEvaluationResponseDto evaluateReport(@PathVariable(value="shareId") String dashboardShareId, @PathVariable(value="reportId") String reportId, @RequestBody AdditionalProcessReportEvaluationFilterDto reportEvaluationFilter, @Valid PaginationRequestDto paginationRequestDto, HttpServletRequest request) {
        return this.executeIfSharingEnabled(() -> this.protectedSharingRestService.evaluateReport(dashboardShareId, reportId, reportEvaluationFilter, paginationRequestDto, request));
    }

    @GetMapping(value={"/share/dashboard/{shareId}/evaluate"})
    public DashboardDefinitionRestDto evaluateDashboard(@PathVariable(value="shareId") String dashboardShareId, HttpServletRequest request) {
        return this.executeIfSharingEnabled(() -> this.protectedSharingRestService.evaluateDashboard(dashboardShareId, request));
    }

    @PostMapping(value={"/variables"})
    public List<ProcessVariableNameResponseDto> getVariableNames(@Valid @RequestBody ProcessVariableNameRequestDto variableRequestDtos, HttpServletRequest request) {
        return this.executeIfSharingEnabled(() -> this.processVariableRestService.getVariableNames(variableRequestDtos, request));
    }

    @PostMapping(value={"/decision-variables/inputs/names"})
    public List<DecisionVariableNameResponseDto> getInputVariableNames(@Valid @RequestBody List<DecisionVariableNameRequestDto> variableRequestDto) {
        return this.executeIfSharingEnabled(() -> this.decisionVariableRestService.getInputVariableNames(variableRequestDto));
    }

    @PostMapping(value={"/decision-variables/outputs/names"})
    public List<DecisionVariableNameResponseDto> getOutputVariableNames(@Valid @RequestBody List<DecisionVariableNameRequestDto> variableRequestDto) {
        return this.executeIfSharingEnabled(() -> this.decisionVariableRestService.getOutputVariableNames(variableRequestDto));
    }

    @PostMapping(value={"/flow-node/flowNodeNames"})
    @CacheRequest
    public FlowNodeNamesResponseDto getFlowNodeNames(@RequestBody FlowNodeIdsToNamesRequestDto request) {
        return this.executeIfSharingEnabled(() -> this.flowNodeRestService.getFlowNodeNames(request));
    }

    @GetMapping(value={"/candidateGroup"})
    public List<GroupDto> getCandidateGroupsByIds(@RequestParam(name="idIn", required=false) String commaSeparatedIdn) {
        return this.executeIfSharingEnabled(() -> this.candidateGroupRestService.getCandidateGroupsByIds(commaSeparatedIdn));
    }

    @GetMapping(value={"/assignee"})
    public List<UserDto> getAssigneesByIds(@RequestParam(name="idIn", required=false) String commaSeparatedIdn) {
        return this.executeIfSharingEnabled(() -> this.assigneeRestService.getAssigneesByIds(commaSeparatedIdn));
    }

    private <C> C executeIfSharingEnabled(Supplier<C> supplier) {
        return (C)this.settingsService.getSettings().getSharingEnabled().filter(isEnabled -> isEnabled).map(isEnabled -> supplier.get()).orElseThrow(() -> new NotAuthorizedException(SHARING_DISABLED_MSG));
    }
}

