/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import com.google.common.collect.Sets;
import io.camunda.optimize.dto.optimize.ReportType;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.SingleReportConfigurationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.TableColumnDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessVisualization;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.NoneGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.ProcessGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.ProcessViewDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizationType;
import io.camunda.optimize.dto.optimize.rest.ProcessRawDataCsvExportRequestDto;
import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.ReportDefinitionExportDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.entities.EntityExportService;
import io.camunda.optimize.service.export.CSVUtils;
import io.camunda.optimize.service.export.CsvExportService;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/export"})
public class ExportRestService {
    public static final String EXPORT_PATH = "/export";
    private final CsvExportService csvExportService;
    private final EntityExportService entityExportService;
    private final SessionService sessionService;
    private final AbstractIdentityService identityService;

    public ExportRestService(CsvExportService csvExportService, EntityExportService entityExportService, SessionService sessionService, AbstractIdentityService identityService) {
        this.csvExportService = csvExportService;
        this.entityExportService = entityExportService;
        this.sessionService = sessionService;
        this.identityService = identityService;
    }

    @GetMapping(value={"report/json/{reportId}/{fileName}"})
    public ResponseEntity<List<ReportDefinitionExportDto>> getJsonReport(@PathVariable(value="reportId") String reportId, @PathVariable(value="fileName") String fileName, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<ReportDefinitionExportDto> jsonReports = this.entityExportService.getReportExportDtosAsUser(userId, Sets.newHashSet((Object[])new String[]{reportId}));
        return this.createJsonResponse(fileName, jsonReports);
    }

    @GetMapping(value={"dashboard/json/{dashboardId}/{fileName}"})
    public ResponseEntity<List<OptimizeEntityExportDto>> getJsonDashboard(@PathVariable(value="dashboardId") String dashboardId, @PathVariable(value="fileName") String fileName, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<OptimizeEntityExportDto> jsonDashboards = this.entityExportService.getCompleteDashboardExportAsUser(userId, dashboardId);
        return this.createJsonResponse(fileName, jsonDashboards);
    }

    @GetMapping(path={"csv/{reportId}/{fileName}"}, produces={"application/octet-stream", "application/json"})
    public ResponseEntity<byte[]> getCsvReport(@PathVariable(value="reportId") String reportId, @PathVariable(value="fileName") String fileName, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.validateAuthorization();
        ZoneId timezone = TimeZoneUtil.extractTimezone(request);
        Optional<byte[]> csvForReport = this.csvExportService.getCsvBytesForEvaluatedReportResult(userId, reportId, timezone);
        return csvForReport.map(csvBytes -> this.createOctetStreamResponse(fileName, (byte[])csvBytes)).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @PostMapping(path={"csv/process/rawData/{fileName}"}, produces={"application/octet-stream", "application/json"})
    public ResponseEntity<byte[]> getRawDataCsv(@PathVariable(value="fileName") String fileName, @Valid @RequestBody ProcessRawDataCsvExportRequestDto request, HttpServletRequest servletRequest) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(servletRequest);
        this.validateAuthorization();
        ZoneId timezone = TimeZoneUtil.extractTimezone(servletRequest);
        SingleProcessReportDefinitionRequestDto reportDefinitionDto = ((SingleProcessReportDefinitionRequestDto.SingleProcessReportDefinitionRequestDtoBuilder)((SingleProcessReportDefinitionRequestDto.SingleProcessReportDefinitionRequestDtoBuilder)((SingleProcessReportDefinitionRequestDto.SingleProcessReportDefinitionRequestDtoBuilder)SingleProcessReportDefinitionRequestDto.builder().reportType(ReportType.PROCESS)).combined(false)).data((ReportDataDto)((ProcessReportDataDto.ProcessReportDataDtoBuilder)((ProcessReportDataDto.ProcessReportDataDtoBuilder)ProcessReportDataDto.builder().definitions(List.of(new ReportDataDefinitionDto(request.getProcessDefinitionKey(), request.getProcessDefinitionVersions(), request.getTenantIds())))).filter(request.getFilter()).configuration(SingleReportConfigurationDto.builder().tableColumns(TableColumnDto.builder().includeNewVariables(false).excludedColumns(this.getAllExcludedFields(request)).includedColumns(request.getIncludedColumns()).build()).build())).view(new ProcessViewDto(ViewProperty.RAW_DATA)).groupBy((ProcessGroupByDto)new NoneGroupByDto()).visualization(ProcessVisualization.TABLE).build())).build();
        return this.createOctetStreamResponse(fileName, this.csvExportService.getCsvBytesForEvaluatedReportResult(userId, (ReportDefinitionDto<?>)reportDefinitionDto, timezone));
    }

    private void validateAuthorization() {
        if (!this.identityService.getEnabledAuthorizations().contains((Object)AuthorizationType.CSV_EXPORT)) {
            throw new ForbiddenException("User not authorized to export CSVs");
        }
    }

    private List<String> getAllExcludedFields(ProcessRawDataCsvExportRequestDto request) {
        List<String> excludedFields = Stream.concat(CSVUtils.extractAllProcessInstanceDtoFieldKeys().stream(), CSVUtils.extractAllPrefixedCountKeys().stream()).collect(Collectors.toList());
        excludedFields.removeAll(request.getIncludedColumns());
        return excludedFields;
    }

    private ResponseEntity<byte[]> createOctetStreamResponse(String fileName, byte[] csvBytesForEvaluatedReportResult) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=" + this.createFileName(fileName, ".csv")})).body((Object)csvBytesForEvaluatedReportResult);
    }

    private <A extends OptimizeEntityExportDto> ResponseEntity<List<A>> createJsonResponse(String fileName, List<A> jsonEntities) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).header("Content-Disposition", new String[]{"attachment; filename=" + this.createFileName(fileName, ".json")})).body(jsonEntities);
    }

    private String createFileName(String fileName, String extension) {
        return fileName == null ? System.currentTimeMillis() + extension : fileName;
    }
}

