/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisRequestDto;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisResponseDto;
import io.camunda.optimize.dto.optimize.query.analysis.DurationChartEntryDto;
import io.camunda.optimize.dto.optimize.query.analysis.FindingsDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierVariableParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.OutlierAnalysisServiceParameters;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessDefinitionParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.VariableTermDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.BranchAnalysisService;
import io.camunda.optimize.service.OutlierAnalysisService;
import io.camunda.optimize.service.export.CSVUtils;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/analysis"})
public class AnalysisRestService {
    public static final String ANALYSIS_PATH = "/analysis";
    private final BranchAnalysisService branchAnalysisService;
    private final OutlierAnalysisService outlierAnalysisService;
    private final SessionService sessionService;

    public AnalysisRestService(BranchAnalysisService branchAnalysisService, OutlierAnalysisService outlierAnalysisService, SessionService sessionService) {
        this.branchAnalysisService = branchAnalysisService;
        this.outlierAnalysisService = outlierAnalysisService;
        this.sessionService = sessionService;
    }

    @PostMapping(value={"/correlation"})
    public BranchAnalysisResponseDto getBranchAnalysis(@RequestBody BranchAnalysisRequestDto branchAnalysisDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        ZoneId timezone = TimeZoneUtil.extractTimezone(request);
        return this.branchAnalysisService.branchAnalysis(userId, branchAnalysisDto, timezone);
    }

    @PostMapping(value={"/flowNodeOutliers"})
    public Map<String, FindingsDto> getFlowNodeOutlierMap(@RequestBody ProcessDefinitionParametersDto parameters, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.validateProvidedFilters(parameters.getFilters());
        OutlierAnalysisServiceParameters<ProcessDefinitionParametersDto> outlierAnalysisParams = new OutlierAnalysisServiceParameters<ProcessDefinitionParametersDto>(parameters, TimeZoneUtil.extractTimezone(request), userId);
        Map<String, FindingsDto> flowNodeOutlierMap = this.outlierAnalysisService.getFlowNodeOutlierMap(outlierAnalysisParams);
        List<Map.Entry> sortedFindings = flowNodeOutlierMap.entrySet().stream().sorted(Comparator.comparing(entry -> ((FindingsDto)entry.getValue()).getHigherOutlier().map(FindingsDto.Finding::getCount).orElse(0L), Comparator.reverseOrder())).toList();
        LinkedHashMap<String, FindingsDto> descendingFindings = new LinkedHashMap<String, FindingsDto>();
        for (Map.Entry finding : sortedFindings) {
            descendingFindings.put((String)finding.getKey(), (FindingsDto)finding.getValue());
        }
        return descendingFindings;
    }

    @PostMapping(value={"/durationChart"})
    public List<DurationChartEntryDto> getCountByDurationChart(@RequestBody FlowNodeOutlierParametersDto parameters, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.validateProvidedFilters(parameters.getFilters());
        OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierAnalysisParams = new OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto>(parameters, TimeZoneUtil.extractTimezone(request), userId);
        return this.outlierAnalysisService.getCountByDurationChart(outlierAnalysisParams);
    }

    @PostMapping(value={"/significantOutlierVariableTerms"})
    public List<VariableTermDto> getSignificantOutlierVariableTerms(@RequestBody FlowNodeOutlierParametersDto parameters, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.validateProvidedFilters(parameters.getFilters());
        OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierAnalysisParams = new OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto>(parameters, TimeZoneUtil.extractTimezone(request), userId);
        return this.outlierAnalysisService.getSignificantOutlierVariableTerms(outlierAnalysisParams);
    }

    @PostMapping(path={"/significantOutlierVariableTerms/processInstanceIdsExport"}, produces={"application/octet-stream", "application/json"})
    @ResponseBody
    public ResponseEntity<byte[]> getSignificantOutlierVariableTermsInstanceIds(@PathVariable(value="fileName") String fileName, @RequestBody FlowNodeOutlierVariableParametersDto parameters, HttpServletRequest request, HttpServletResponse response) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.validateProvidedFilters(parameters.getFilters());
        Object resultFileName = fileName == null ? System.currentTimeMillis() + ".csv" : fileName;
        OutlierAnalysisServiceParameters<FlowNodeOutlierVariableParametersDto> outlierAnalysisParams = new OutlierAnalysisServiceParameters<FlowNodeOutlierVariableParametersDto>(parameters, TimeZoneUtil.extractTimezone(request), userId);
        List<String[]> processInstanceIdsCsv = CSVUtils.mapIdList(this.outlierAnalysisService.getSignificantOutlierVariableTermsInstanceIds(outlierAnalysisParams));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{"attachment; filename=" + (String)resultFileName})).body((Object)CSVUtils.mapCsvLinesToCsvBytes(processInstanceIdsCsv, ','));
    }

    private void validateProvidedFilters(List<ProcessFilterDto<?>> filters) {
        if (filters.stream().anyMatch(filter -> FilterApplicationLevel.VIEW == filter.getFilterLevel())) {
            throw new BadRequestException("View level filters cannot be applied during analysis");
        }
    }
}

