/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.zeebe;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ZeebeRecordDto<VALUE extends RecordValue, INTENT extends Intent>
implements Record<VALUE> {
    private long position;
    private Long sequence;
    private long sourceRecordPosition;
    private long key;
    private long timestamp;
    private int partitionId;
    private RecordType recordType;
    private RejectionType rejectionType;
    private String rejectionReason;
    private String brokerVersion;
    private ValueType valueType;
    private VALUE value;
    private INTENT intent;
    private Map<String, Object> authorizations;
    private long operationReference;

    public String toJson() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public OffsetDateTime getDateForTimestamp() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault());
    }

    public long getPosition() {
        return this.position;
    }

    public long getSourceRecordPosition() {
        return this.sourceRecordPosition;
    }

    public long getKey() {
        return this.key;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public INTENT getIntent() {
        return this.intent;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public Map<String, Object> getAuthorizations() {
        return this.authorizations;
    }

    public int getRecordVersion() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public VALUE getValue() {
        return this.value;
    }

    public long getOperationReference() {
        return this.operationReference;
    }

    public Record<VALUE> copyOf() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void setOperationReference(long operationReference) {
        this.operationReference = operationReference;
    }

    public void setValue(VALUE value) {
        this.value = value;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public void setAuthorizations(Map<String, Object> authorizations) {
        this.authorizations = authorizations;
    }

    public void setBrokerVersion(String brokerVersion) {
        this.brokerVersion = brokerVersion;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public void setRejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
    }

    public void setRecordType(RecordType recordType) {
        this.recordType = recordType;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public void setIntent(INTENT intent) {
        this.intent = intent;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public void setSourceRecordPosition(long sourceRecordPosition) {
        this.sourceRecordPosition = sourceRecordPosition;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZeebeRecordDto;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "ZeebeRecordDto(super=" + super.toString() + ", position=" + this.getPosition() + ", sequence=" + this.getSequence() + ", sourceRecordPosition=" + this.getSourceRecordPosition() + ", key=" + this.getKey() + ", timestamp=" + this.getTimestamp() + ", partitionId=" + this.getPartitionId() + ", recordType=" + String.valueOf(this.getRecordType()) + ", rejectionType=" + String.valueOf(this.getRejectionType()) + ", rejectionReason=" + this.getRejectionReason() + ", brokerVersion=" + this.getBrokerVersion() + ", valueType=" + String.valueOf(this.getValueType()) + ", value=" + String.valueOf(this.getValue()) + ", intent=" + String.valueOf(this.getIntent()) + ", authorizations=" + String.valueOf(this.getAuthorizations()) + ", operationReference=" + this.getOperationReference() + ")";
    }

    public static final class Fields {
        public static final String position = "position";
        public static final String sequence = "sequence";
        public static final String sourceRecordPosition = "sourceRecordPosition";
        public static final String key = "key";
        public static final String timestamp = "timestamp";
        public static final String partitionId = "partitionId";
        public static final String recordType = "recordType";
        public static final String rejectionType = "rejectionType";
        public static final String rejectionReason = "rejectionReason";
        public static final String brokerVersion = "brokerVersion";
        public static final String valueType = "valueType";
        public static final String value = "value";
        public static final String intent = "intent";
        public static final String authorizations = "authorizations";
        public static final String operationReference = "operationReference";
    }
}

