/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize;

import io.camunda.optimize.MetricEnum;
import io.camunda.optimize.dto.zeebe.ZeebeRecordDto;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OptimizeMetrics {
    public static final String RECORD_TYPE_TAG = "RECORD_TYPE";
    public static final String PARTITION_ID_TAG = "PARTITION_ID";
    public static final String METRICS_ENDPOINT = "metrics";

    public static <T extends ZeebeRecordDto<?, ?>> void recordOverallEntitiesImportTime(List<T> entities) {
        OffsetDateTime currentTime = LocalDateUtil.getCurrentDateTime();
        entities.forEach(entity -> OptimizeMetrics.getTimer(MetricEnum.OVERALL_IMPORT_TIME_METRIC, entity.getValueType().name(), entity.getPartitionId()).record(currentTime.toInstant().toEpochMilli() - entity.getTimestamp(), TimeUnit.MILLISECONDS));
    }

    public static Timer getTimer(MetricEnum metric, String recordType, Integer partitionId) {
        return Timer.builder((String)metric.getName()).description(metric.getDescription()).tag(RECORD_TYPE_TAG, recordType).tag(PARTITION_ID_TAG, String.valueOf(partitionId)).register((MeterRegistry)Metrics.globalRegistry);
    }
}

