/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.repository;

import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import io.camunda.optimize.test.repository.TestIndexRepository;
import java.io.IOException;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class TestIndexRepositoryES
implements TestIndexRepository {
    private final OptimizeElasticsearchClient esClient;

    public TestIndexRepositoryES(OptimizeElasticsearchClient esClient) {
        this.esClient = esClient;
    }

    @Override
    public Set<String> getAllIndexNames() {
        GetIndexRequest request = GetIndexRequest.of(i -> i.index("*", new String[0]));
        try {
            return this.esClient.elasticsearchClient().indices().get(request).result().keySet();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

