/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension;

import io.camunda.optimize.OptimizeTomcatConfig;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import io.camunda.optimize.service.util.configuration.DatabaseType;
import io.camunda.optimize.test.util.PropertyUtil;
import java.util.Properties;
import org.springframework.context.ApplicationContext;

public class IntegrationTestConfigurationUtil {
    private static final String DEFAULT_PROPERTIES_PATH = "integration-extensions.properties";
    private static final Properties PROPERTIES = PropertyUtil.loadProperties("integration-extensions.properties");

    private IntegrationTestConfigurationUtil() {
    }

    public static String getZeebeDockerVersion() {
        return PROPERTIES.getProperty("zeebe.docker.version");
    }

    public static DatabaseType getDatabaseType() {
        return DatabaseType.fromString((String)PROPERTIES.getProperty("database.type"));
    }

    public static String getEmbeddedOptimizeEndpoint(ApplicationContext applicationContext) {
        return "http://localhost:" + ((OptimizeTomcatConfig)applicationContext.getBean(OptimizeTomcatConfig.class)).getPort("httpPort") + ((OptimizeTomcatConfig)applicationContext.getBean(OptimizeTomcatConfig.class)).getContextPath().orElse("");
    }

    public static String getEmbeddedOptimizeRestApiEndpoint(ApplicationContext applicationContext) {
        return IntegrationTestConfigurationUtil.getEmbeddedOptimizeEndpoint(applicationContext) + "/api";
    }

    public static ConfigurationService createItConfigurationService() {
        return ConfigurationServiceBuilder.createConfiguration().loadConfigurationFrom(new String[]{"service-config.yaml", "it/it-config-ccsm.yaml"}).build();
    }

    public static int getHttpTimeoutMillis() {
        return Integer.parseInt(System.getProperty("httpTestTimeout", "10000"));
    }

    public static int getDatabaseMockServerPort() {
        return Integer.parseInt(System.getProperty("databaseMockServerPort", "1080"));
    }
}

