/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;

public class ClockActuatorClient {
    private final HttpClient httpClient = HttpClient.newBuilder().build();
    private final ObjectWriter objectWriter = new ObjectMapper().writer();
    private final String monitoringAddress;

    public ClockActuatorClient(String zeebeMonitoringAddress) {
        this.monitoringAddress = zeebeMonitoringAddress;
    }

    public Instant pinZeebeTime(Instant pinAt) throws IOException, InterruptedException {
        this.sendRequest("POST", "actuator/clock/pin", new PinRequestDto(pinAt));
        return pinAt;
    }

    private void sendRequest(String method, String endpoint, PinRequestDto requestDto) throws IOException, InterruptedException {
        URI uri = URI.create(String.format("http://%s/%s", this.monitoringAddress, endpoint));
        HttpRequest.BodyPublisher body = requestDto == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofByteArray(this.objectWriter.writeValueAsBytes((Object)requestDto));
        HttpRequest httpRequest = HttpRequest.newBuilder(uri).method(method, body).header("Content-Type", "application/json").build();
        HttpResponse<String> httpResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (httpResponse.statusCode() != 200) {
            throw new IllegalStateException("Pinning time failed: " + httpResponse.body());
        }
    }

    private static final class PinRequestDto {
        @JsonProperty(value="epochMilli")
        private final long epochMilli;

        private PinRequestDto(Instant pinAt) {
            this.epochMilli = pinAt.toEpochMilli();
        }
    }
}

