/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateUnit;
import io.camunda.optimize.service.util.DateFilterUtil;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class DateFilterUtilTest {
    private static final OffsetDateTime CURRENT_TIME = OffsetDateTime.parse("2020-07-25T10:15:25+01:00", DateTimeFormatter.ISO_OFFSET_DATE_TIME);

    @ParameterizedTest
    @MethodSource(value={"dateFilterUnitsAndExpectedStartOfInterval"})
    public void testStartOfCurrentInterval(DateUnit unit, String expectedStartOfCurrentInterval) {
        OffsetDateTime expected = OffsetDateTime.parse(expectedStartOfCurrentInterval, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        OffsetDateTime result = DateFilterUtil.getStartOfCurrentInterval((OffsetDateTime)CURRENT_TIME, (DateUnit)unit);
        Assertions.assertThat((OffsetDateTime)result).isEqualTo((Object)expected);
    }

    private static Stream<Arguments> dateFilterUnitsAndExpectedStartOfInterval() {
        return Stream.of(Arguments.of((Object[])new Object[]{DateUnit.MINUTES, "2020-07-25T10:15:00+01:00"}), Arguments.of((Object[])new Object[]{DateUnit.HOURS, "2020-07-25T10:00:00+01:00"}), Arguments.of((Object[])new Object[]{DateUnit.DAYS, "2020-07-25T00:00:00+01:00"}), Arguments.of((Object[])new Object[]{DateUnit.WEEKS, "2020-07-20T00:00:00+01:00"}), Arguments.of((Object[])new Object[]{DateUnit.MONTHS, "2020-07-01T00:00:00+01:00"}), Arguments.of((Object[])new Object[]{DateUnit.QUARTERS, "2020-07-01T00:00:00+01:00"}), Arguments.of((Object[])new Object[]{DateUnit.YEARS, "2020-01-01T00:00:00+01:00"}));
    }
}

