/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.DataImportSourceType;
import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.datasource.EngineDataSourceDto;
import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.service.util.DatabaseHelper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DatabaseHelperTest {
    public static final String ALIAS = "alias";

    @Test
    void shouldConstructKeyWithDatabaseTypeAndEngineAlias() {
        String databaseType = DataImportSourceType.ZEEBE.toString();
        String result = DatabaseHelper.constructKey((String)databaseType, (String)ALIAS);
        Assertions.assertThat((String)result).isEqualTo(databaseType + "-alias");
    }

    @Test
    void shouldConstructKeyWithIngestedDataDataSourceDto() {
        String databaseType = DataImportSourceType.INGESTED_DATA.toString();
        EngineDataSourceDto dataSourceDto = new EngineDataSourceDto(ALIAS);
        String result = DatabaseHelper.constructKey((String)databaseType, (DataSourceDto)dataSourceDto);
        Assertions.assertThat((String)result).isEqualTo(databaseType + "-alias");
    }

    @Test
    void shouldConstructKeyWithEngineDataSourceDto() {
        String databaseType = DataImportSourceType.ENGINE.toString();
        EngineDataSourceDto dataSourceDto = new EngineDataSourceDto(ALIAS);
        String result = DatabaseHelper.constructKey((String)databaseType, (DataSourceDto)dataSourceDto);
        Assertions.assertThat((String)result).isEqualTo(databaseType + "-alias");
    }

    @Test
    void shouldConstructKeyWithZeebeDataSourceDto() {
        String databaseType = DataImportSourceType.ZEEBE.toString();
        int partitionId = 42;
        ZeebeDataSourceDto zeebeDataSourceDto = new ZeebeDataSourceDto(ALIAS, 42);
        String result = DatabaseHelper.constructKey((String)databaseType, (DataSourceDto)zeebeDataSourceDto);
        Assertions.assertThat((String)result).isEqualTo(databaseType + "-alias42");
    }
}

