/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.FlowNodeDataDto;
import io.camunda.optimize.service.util.BpmnModelUtil;
import io.camunda.optimize.util.ZeebeBpmnModels;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;

public class BpmnModelUtilTest {
    public static final String PROCESS_NAME = "processName";
    public static final String END_EVENT_TYPE = "endEvent";
    public static final String SERVICE_TASK_TYPE = "serviceTask";
    public static final String SIMPLE_SERVICE_TASK_PROCESS = Bpmn.convertToString((BpmnModelInstance)ZeebeBpmnModels.createSimpleServiceTaskProcess("processName"));

    @Test
    void shouldParseBpmnModel() {
        BpmnModelInstance modelInstance = BpmnModelUtil.parseBpmnModel((String)SIMPLE_SERVICE_TASK_PROCESS);
        Assertions.assertThat((Object)modelInstance).isNotNull();
    }

    @Test
    void shouldExtractFlowNodeData() {
        List flowNodeData = BpmnModelUtil.extractFlowNodeData((String)SIMPLE_SERVICE_TASK_PROCESS);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)flowNodeData).isNotNull()).isNotEmpty()).extracting(new Function[]{FlowNodeDataDto::getId, FlowNodeDataDto::getType, FlowNodeDataDto::getName}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"startEvent", "startEvent", "startEvent"}), Tuple.tuple((Object[])new Object[]{"service_task", SERVICE_TASK_TYPE, "service_task"}), Tuple.tuple((Object[])new Object[]{"end", END_EVENT_TYPE, null})});
    }

    @Test
    void shouldExtractUserTaskNames() {
        String bpmnModelInstance = Bpmn.convertToString((BpmnModelInstance)ZeebeBpmnModels.createSimpleUserTaskProcess(PROCESS_NAME));
        Map userTaskNames = BpmnModelUtil.extractUserTaskNames((String)bpmnModelInstance);
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)userTaskNames).isNotNull()).isNotEmpty()).containsKey((Object)"user_task")).containsValue((Object)"user_task");
    }

    @Test
    void shouldExtractProcessDefinitionName() {
        Optional processName = BpmnModelUtil.extractProcessDefinitionName((String)PROCESS_NAME, (String)SIMPLE_SERVICE_TASK_PROCESS);
        ((OptionalAssert)Assertions.assertThat((Optional)processName).isPresent()).get().isEqualTo((Object)PROCESS_NAME);
    }

    @Test
    void shouldNotExtractNameForUnkownProcessDefinitionKey() {
        Optional processName = BpmnModelUtil.extractProcessDefinitionName((String)"someUnknownKey", (String)SIMPLE_SERVICE_TASK_PROCESS);
        Assertions.assertThat((Optional)processName).isNotPresent();
    }

    @Test
    void shouldExtractFlowNodeNames() {
        List flowNodeData = BpmnModelUtil.extractFlowNodeData((String)SIMPLE_SERVICE_TASK_PROCESS);
        Map flowNodeNames = BpmnModelUtil.extractFlowNodeNames((List)flowNodeData);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)flowNodeNames).isNotNull()).isNotEmpty()).containsExactlyEntriesOf((Map)new HashMap<String, String>(){
            {
                this.put("startEvent", "startEvent");
                this.put("service_task", "service_task");
                this.put("end", null);
            }
        });
    }
}

