/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.panelnotification;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.cloud.TokenResponseDto;
import io.camunda.optimize.rest.cloud.CCSaaSM2MTokenProvider;
import io.camunda.optimize.rest.cloud.CCSaaSNotificationClient;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class CCSaaSNotificationClientTest {
    @Mock
    private CCSaaSM2MTokenProvider m2mTokenProvider;
    private CCSaaSNotificationClient underTest;

    @BeforeEach
    public void setup() {
        ConfigurationService configurationService = ConfigurationServiceBuilder.createDefaultConfiguration();
        configurationService.getPanelNotificationConfiguration().setM2mTokenAudience("someAudience");
        this.underTest = new CCSaaSNotificationClient(new ObjectMapper(), configurationService, this.m2mTokenProvider);
    }

    @Test
    public void notificationTokenIsRefreshedWhenExpired() {
        TokenResponseDto fastExpiringToken = new TokenResponseDto();
        fastExpiringToken.setAccessToken("expiredAccessToken");
        fastExpiringToken.setExpiresIn(1L);
        Mockito.when((Object)this.m2mTokenProvider.retrieveM2MToken((String)ArgumentMatchers.any())).thenReturn((Object)fastExpiringToken);
        this.underTest.refreshAccessTokenIfRequired();
        ((CCSaaSM2MTokenProvider)Mockito.verify((Object)this.m2mTokenProvider, (VerificationMode)Mockito.times((int)1))).retrieveM2MToken((String)ArgumentMatchers.any());
        this.underTest.refreshAccessTokenIfRequired();
        ((CCSaaSM2MTokenProvider)Mockito.verify((Object)this.m2mTokenProvider, (VerificationMode)Mockito.times((int)2))).retrieveM2MToken((String)ArgumentMatchers.any());
    }

    @Test
    public void notificationTokenIsNotRefreshedWhenNotExpired() {
        TokenResponseDto notExpiredToken = new TokenResponseDto();
        notExpiredToken.setAccessToken("tokenWithLongExpiryTime");
        notExpiredToken.setExpiresIn(999999999L);
        Mockito.when((Object)this.m2mTokenProvider.retrieveM2MToken((String)ArgumentMatchers.any())).thenReturn((Object)notExpiredToken);
        this.underTest.refreshAccessTokenIfRequired();
        ((CCSaaSM2MTokenProvider)Mockito.verify((Object)this.m2mTokenProvider, (VerificationMode)Mockito.times((int)1))).retrieveM2MToken((String)ArgumentMatchers.any());
        this.underTest.refreshAccessTokenIfRequired();
        ((CCSaaSM2MTokenProvider)Mockito.verify((Object)this.m2mTokenProvider, (VerificationMode)Mockito.times((int)1))).retrieveM2MToken((String)ArgumentMatchers.any());
    }
}

