/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.processdefinition;

import io.camunda.client.api.response.Process;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.dto.optimize.DataImportSourceType;
import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.FlowNodeDataDto;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.util.ZeebeBpmnModels;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AdHocSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;

public class ZeebeProcessDefinitionImportIT
extends AbstractCCSMIT {
    @Test
    public void importZeebeProcess_allDataSavedToDefinition() {
        String processName = "someProcess";
        BpmnModelInstance simpleProcess = ZeebeBpmnModels.createSimpleUserTaskProcess("someProcess");
        Process deployedProcess = this.deployProcessAndStartInstance(simpleProcess);
        this.waitUntilNumberOfDefinitionsExported(1);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).singleElement()).satisfies(new ThrowingConsumer[]{importedDef -> {
            Assertions.assertThat((String)importedDef.getId()).isEqualTo(String.valueOf(deployedProcess.getProcessDefinitionKey()));
            Assertions.assertThat((String)importedDef.getKey()).isEqualTo(deployedProcess.getBpmnProcessId());
            Assertions.assertThat((String)importedDef.getVersion()).isEqualTo(String.valueOf(deployedProcess.getVersion()));
            if (ZeebeProcessDefinitionImportIT.isZeebeVersionPre86()) {
                Assertions.assertThat((String)importedDef.getVersionTag()).isNull();
            } else {
                Assertions.assertThat((String)importedDef.getVersionTag()).isEqualTo("v1");
            }
            Assertions.assertThat((Comparable)importedDef.getType()).isEqualTo((Object)DefinitionType.PROCESS);
            Assertions.assertThat((String)importedDef.getBpmn20Xml()).isEqualTo(Bpmn.convertToString((BpmnModelInstance)simpleProcess));
            Assertions.assertThat((String)importedDef.getName()).isEqualTo("someProcess");
            Assertions.assertThat((Comparable)importedDef.getDataSource().getType()).isEqualTo((Object)DataImportSourceType.ZEEBE);
            Assertions.assertThat((String)importedDef.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)importedDef.getTenantId()).isEqualTo("<default>");
            Assertions.assertThat((boolean)importedDef.isDeleted()).isFalse();
            Assertions.assertThat((Map)importedDef.getUserTaskNames()).containsEntry((Object)"user_task", (Object)"user_task");
            Assertions.assertThat((List)importedDef.getFlowNodeData()).containsExactlyInAnyOrder((Object[])new FlowNodeDataDto[]{new FlowNodeDataDto("startEvent", "startEvent", "startEvent"), new FlowNodeDataDto("user_task", "user_task", "userTask"), new FlowNodeDataDto("end", null, "endEvent")});
        }});
    }

    @Test
    public void importZeebeProcess_unnamedProcessUsesProcessIdAsName() {
        BpmnModelInstance noNameStartEventProcess = ((StartEventBuilder)Bpmn.createExecutableProcess().startEvent("startEvent").name("startEvent")).done();
        Process deployedProcess = this.deployProcessAndStartInstance(noNameStartEventProcess);
        this.waitUntilNumberOfDefinitionsExported(1);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).singleElement()).satisfies(new ThrowingConsumer[]{importedDef -> {
            Assertions.assertThat((String)importedDef.getId()).isEqualTo(String.valueOf(deployedProcess.getProcessDefinitionKey()));
            Assertions.assertThat((String)importedDef.getKey()).isEqualTo(deployedProcess.getBpmnProcessId());
            Assertions.assertThat((String)importedDef.getVersion()).isEqualTo(String.valueOf(deployedProcess.getVersion()));
            Assertions.assertThat((String)importedDef.getVersionTag()).isNull();
            Assertions.assertThat((Comparable)importedDef.getType()).isEqualTo((Object)DefinitionType.PROCESS);
            Assertions.assertThat((String)importedDef.getBpmn20Xml()).isEqualTo(Bpmn.convertToString((BpmnModelInstance)noNameStartEventProcess));
            Assertions.assertThat((String)importedDef.getName()).isEqualTo(deployedProcess.getBpmnProcessId());
            Assertions.assertThat((Comparable)importedDef.getDataSource().getType()).isEqualTo((Object)DataImportSourceType.ZEEBE);
            Assertions.assertThat((String)importedDef.getDataSource().getName()).isEqualTo(this.getConfiguredZeebeName());
            Assertions.assertThat((String)importedDef.getTenantId()).isEqualTo("<default>");
            Assertions.assertThat((boolean)importedDef.isDeleted()).isFalse();
            Assertions.assertThat((Map)importedDef.getUserTaskNames()).isEmpty();
            Assertions.assertThat((List)importedDef.getFlowNodeData()).containsExactlyInAnyOrder((Object[])new FlowNodeDataDto[]{new FlowNodeDataDto("startEvent", "startEvent", "startEvent")});
        }});
    }

    @Test
    public void importZeebeProcess_multipleProcessesDeployed() {
        String firstProcessName = "firstProcess";
        this.deployProcessAndStartInstance(ZeebeBpmnModels.createSimpleServiceTaskProcess("firstProcess"));
        String secondProcessName = "secondProcess";
        this.deployProcessAndStartInstance(ZeebeBpmnModels.createSimpleServiceTaskProcess("secondProcess"));
        this.waitUntilNumberOfDefinitionsExported(2);
        this.importAllZeebeEntitiesFromScratch();
        ((ListAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).hasSize(2)).extracting(DefinitionOptimizeResponseDto::getName).containsExactlyInAnyOrder((Object[])new String[]{"firstProcess", "secondProcess"});
    }

    @Test
    public void importZeebeProcess_multipleProcessesDeployedOnDifferentDays() {
        String firstProcessName = "firstProcess";
        this.deployProcessAndStartInstance(ZeebeBpmnModels.createSimpleServiceTaskProcess("firstProcess"));
        try {
            zeebeExtension.setClock(Instant.now().plus(1L, ChronoUnit.DAYS));
        }
        catch (IOException | InterruptedException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        String secondProcessName = "secondProcess";
        this.deployProcessAndStartInstance(ZeebeBpmnModels.createSimpleServiceTaskProcess("secondProcess"));
        this.waitUntilDefinitionWithIdExported("firstProcess");
        this.waitUntilDefinitionWithIdExported("secondProcess");
        this.importAllZeebeEntitiesFromScratch();
        ((ListAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).hasSize(2)).extracting(DefinitionOptimizeResponseDto::getName).containsExactlyInAnyOrder((Object[])new String[]{"firstProcess", "secondProcess"});
    }

    @Test
    public void importZeebeProcess_multipleVersionsOfSameProcess() {
        String processName = "someProcess";
        Process firstVersion = this.deployProcessAndStartInstance(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        Process secondVersion = this.deployProcessAndStartInstance(ZeebeBpmnModels.createStartEndProcess("someProcess"));
        this.waitUntilNumberOfDefinitionsExported(2);
        this.importAllZeebeEntitiesFromScratch();
        ((ListAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).hasSize(2)).extracting(new Function[]{DefinitionOptimizeResponseDto::getId, DefinitionOptimizeResponseDto::getVersion}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{String.valueOf(firstVersion.getProcessDefinitionKey()), String.valueOf(firstVersion.getVersion())}), Tuple.tuple((Object[])new Object[]{String.valueOf(secondVersion.getProcessDefinitionKey()), String.valueOf(secondVersion.getVersion())})});
    }

    @Test
    public void importZeebeProcess_multipleProcessOverMultipleBatches() {
        embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().setMaxImportPageSize(1);
        embeddedOptimizeExtension.reloadConfiguration();
        String firstProcessName = "firstProcess";
        this.deployProcessAndStartInstance(ZeebeBpmnModels.createSimpleServiceTaskProcess("firstProcess"));
        String secondProcessName = "secondProcess";
        this.deployProcessAndStartInstance(ZeebeBpmnModels.createSimpleServiceTaskProcess("secondProcess"));
        this.waitUntilNumberOfDefinitionsExported(2);
        this.importAllZeebeEntitiesFromScratch();
        ((ListAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).hasSize(1)).extracting(DefinitionOptimizeResponseDto::getName).containsExactlyInAnyOrder((Object[])new String[]{"firstProcess"});
        this.importAllZeebeEntitiesFromLastIndex();
        ((ListAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).hasSize(2)).extracting(DefinitionOptimizeResponseDto::getName).containsExactlyInAnyOrder((Object[])new String[]{"firstProcess", "secondProcess"});
    }

    @Test
    public void importZeebeProcess_processContainsNewBpmnElementsIntroducedWith820() {
        BpmnModelInstance model = this.readProcessDiagramAsInstance("/bpmn/compatibility/adventure.bpmn");
        zeebeExtension.deployProcess(model).getBpmnProcessId();
        this.waitUntilNumberOfDefinitionsExported(1);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).singleElement()).extracting(ProcessDefinitionOptimizeDto::getFlowNodeData).satisfies(new ThrowingConsumer[]{flowNodeDataDtos -> Assertions.assertThat((List)flowNodeDataDtos).extracting(FlowNodeDataDto::getId).contains((Object[])new String[]{"linkIntermediateThrowEventId", "linkIntermediateCatchEventId", "undefinedTaskId", "escalationIntermediateThrowEventId", "escalationNonInterruptingBoundaryEventId", "escalationBoundaryEventId", "escalationNonInterruptingStartEventId", "escalationStartEventId", "escalationEndEventId"})});
    }

    @DisabledIf(value="isZeebeVersionPre83")
    @Test
    public void importZeebeProcess_processContainsNewBpmnElementsIntroducedWith830() {
        zeebeExtension.deployProcess(ZeebeBpmnModels.createProcessWith83SignalEvents("startSignalName"));
        this.waitUntilNumberOfDefinitionsExported(1);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).singleElement()).extracting(ProcessDefinitionOptimizeDto::getFlowNodeData).satisfies(new ThrowingConsumer[]{flowNodeDataDtos -> Assertions.assertThat((List)flowNodeDataDtos).extracting(FlowNodeDataDto::getId).contains((Object[])new String[]{"signalStartEvent", "signalStartInterruptingSubProcessEvent", "signalStartNonInterruptingSubProcessEvent", "signalIntermediateCatchEventAttachedToEventBasedGateway", "signalIntermediateThrowEvent", "signalIntermediateCatchEvent", "signalIntermediateBoundaryInterruptingEvent", "signalIntermediateBoundaryNonInterruptingEvent", "signalEndEvent"})});
    }

    @EnabledIf(value="isZeebeVersion87_OrLater")
    @Test
    public void importZeebeProcess_processContainsAdHocSubProcess() {
        BpmnModelInstance adHocSubProcessModel = ZeebeBpmnModels.createAdHocSubProcess("someProcess", process -> ((AdHocSubProcessBuilder)process.zeebeActiveElementsCollectionExpression("activateElements")).task("task"));
        zeebeExtension.deployProcess(adHocSubProcessModel).getBpmnProcessId();
        this.waitUntilNumberOfDefinitionsExported(1);
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).singleElement()).extracting(ProcessDefinitionOptimizeDto::getFlowNodeData).satisfies(new ThrowingConsumer[]{flowNodeDataDtos -> Assertions.assertThat((List)flowNodeDataDtos).extracting(FlowNodeDataDto::getId).contains((Object[])new String[]{"startEvent", "adhocSubProcess", "task", "end"})});
    }

    @DisabledIf(value="isZeebeVersionWithMultiTenancy")
    @Test
    public void importZeebeProcess_defaultTenantIdForRecordsWithoutTenantId() {
        this.deployProcessAndStartInstance(ZeebeBpmnModels.createSimpleServiceTaskProcess("someProcess"));
        this.waitUntilDefinitionWithIdExported("someProcess");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).extracting(DefinitionOptimizeResponseDto::getTenantId).singleElement()).isEqualTo((Object)"<default>");
    }

    @EnabledIf(value="isZeebeVersionWithMultiTenancy")
    @Test
    public void tenantIdImported_processDefinitionData() {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("aProcess"));
        this.waitUntilDefinitionWithIdExported("aProcess");
        String expectedTenantId = "testTenant";
        this.setTenantIdForExportedZeebeRecords("process", "testTenant");
        this.importAllZeebeEntitiesFromScratch();
        ((ObjectAssert)Assertions.assertThat(databaseIntegrationTestExtension.getAllProcessDefinitions()).extracting(DefinitionOptimizeResponseDto::getTenantId).singleElement()).isEqualTo((Object)"testTenant");
    }

    private Process deployProcessAndStartInstance(BpmnModelInstance simpleProcess) {
        Process deployedProcess = zeebeExtension.deployProcess(simpleProcess);
        zeebeExtension.startProcessInstanceForProcess(deployedProcess.getBpmnProcessId());
        return deployedProcess;
    }
}

