/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.client.api.response.Process;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.variable.SimpleProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.optimize.util.ZeebeBpmnModels;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;

public class ZeebeVariableUpdateImportIT
extends AbstractCCSMIT {
    private final String PROCESS_ID = "demoProcess";
    private final Map<String, Object> VARIABLES = this.generateVariables();
    private final Map<String, Object> UPDATED_VARIABLES = this.generateUpdatedVariables();

    @Test
    public void zeebeVariableImport_importRecordsForTheCreationAndTheUpdateOfProcessVariablesOnSameBatch() {
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(this.VARIABLES);
        zeebeExtension.addVariablesToScope(processInstanceKey, this.UPDATED_VARIABLES, true);
        this.waitUntilNumberOfDefinitionsExported(1);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(5);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance);
    }

    @Test
    public void zeebeVariableImport_importRecordsForTheCreationAndTheUpdateOfProcessVariablesOnDifferentBatch() {
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(this.VARIABLES);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(5);
        this.importAllZeebeEntitiesFromScratch();
        zeebeExtension.addVariablesToScope(processInstanceKey, this.UPDATED_VARIABLES, true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(5);
        this.importAllZeebeEntitiesFromLastIndex();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance);
    }

    @Test
    public void zeebeVariableImport_updateVariablesForInstancesInSeveralDefinitions() {
        long processInstanceKey1 = this.deployProcessAndStartProcessInstanceWithVariables(this.VARIABLES);
        zeebeExtension.addVariablesToScope(processInstanceKey1, this.UPDATED_VARIABLES, true);
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("demoProcess"));
        long processInstanceKey2 = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), this.VARIABLES);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(10);
        this.importAllZeebeEntitiesFromScratch();
        zeebeExtension.addVariablesToScope(processInstanceKey2, this.UPDATED_VARIABLES, true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(10);
        this.importAllZeebeEntitiesFromLastIndex();
        ProcessInstanceDto savedProcessInstance1 = this.getProcessInstanceForId(String.valueOf(processInstanceKey1));
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance1);
        ProcessInstanceDto savedProcessInstance2 = this.getProcessInstanceForId(String.valueOf(processInstanceKey2));
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance2);
    }

    @Test
    public void zeebeVariableImport_updateVariableValueWithNullGetsIgnored() {
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(Map.of("var1", "someValue"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(1);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        String flowNodeId = this.getFlowNodeInstanceIdFromProcessInstanceForActivity(savedProcessInstance, "service_task");
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), Map.of("var1", "flowNodeInstanceScopeValue"), true);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(2);
        this.importAllZeebeEntitiesFromLastIndex();
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        newVariables.put("var1", null);
        zeebeExtension.addVariablesToScope(processInstanceKey, newVariables, true);
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), newVariables, true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(2);
        this.importAllZeebeEntitiesFromLastIndex();
        savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("someValue"), "String"}), Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("flowNodeInstanceScopeValue"), "String"})});
    }

    @Test
    public void zeebeVariableImport_variableNameOnSeveralScopesOnlyProcessLevelGetsUpdated() {
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(Map.of("var1", "someValue"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        String flowNodeId = this.getFlowNodeInstanceIdFromProcessInstanceForActivity(savedProcessInstance, "service_task");
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), Map.of("var1", "flowNodeInstanceScopeValue"), true);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(2);
        this.importAllZeebeEntitiesFromLastIndex();
        zeebeExtension.addVariablesToScope(processInstanceKey, Map.of("var1", "processInstanceScopeUpdatedValue"), true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromLastIndex();
        savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("processInstanceScopeUpdatedValue"), "String"}), Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("flowNodeInstanceScopeValue"), "String"})});
    }

    @Test
    public void zeebeVariableImport_variableNameOnSeveralScopesOnlyFlowNodeLevelGetsUpdated() {
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(Map.of("var1", "processInstanceScopeValue"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(1);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        String flowNodeId = this.getFlowNodeInstanceIdFromProcessInstanceForActivity(savedProcessInstance, "service_task");
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), Map.of("var1", "flowNodeInstanceScopeValue"), true);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(2);
        this.importAllZeebeEntitiesFromLastIndex();
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), Map.of("var1", "flowNodeInstanceScopeUpdatedValue"), true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromLastIndex();
        savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("processInstanceScopeValue"), "String"}), Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("flowNodeInstanceScopeUpdatedValue"), "String"})});
    }

    @Test
    public void zeebeVariableImport_updateTheTypeOfVariables() {
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(this.VARIABLES);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(5);
        this.importAllZeebeEntitiesFromScratch();
        zeebeExtension.addVariablesToScope(processInstanceKey, Map.of("var1", false, "var2", "someValue", "var3", "", "var4", true, "var5", 123.0), true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(5);
        this.importAllZeebeEntitiesFromLastIndex();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("false"), "Boolean"}), Tuple.tuple((Object[])new Object[]{"var2", Collections.singletonList("someValue"), "String"}), Tuple.tuple((Object[])new Object[]{"var3", Collections.singletonList(""), "String"}), Tuple.tuple((Object[])new Object[]{"var4", Collections.singletonList("true"), "Boolean"}), Tuple.tuple((Object[])new Object[]{"var5", Collections.singletonList("123.0"), "Double"})});
    }

    @Test
    public void zeebeVariableImport_updateFlowNodeLevelVariableWithPropagationOnlyUpdatesFlowNodeVariable() {
        ProcessInstanceEvent processInstanceEvent = this.deployProcessAndStartProcessInstance();
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceEvent.getProcessInstanceKey()));
        String flowNodeId = this.getFlowNodeInstanceIdFromProcessInstanceForActivity(savedProcessInstance, "service_task");
        zeebeExtension.addVariablesToScope(processInstanceEvent.getProcessInstanceKey(), Map.of("var1", "processInstanceScopeValue"), true);
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), Map.of("var1", "flowNodeInstanceScopeValue"), true);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(2);
        this.importAllZeebeEntitiesFromLastIndex();
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), Map.of("var1", "updatedValue"), false);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromLastIndex();
        savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceEvent.getProcessInstanceKey()));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("processInstanceScopeValue"), "String"}), Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("updatedValue"), "String"})});
    }

    @Test
    public void zeebeVariableImport_updateVariableSeveralTimesInSameBatch() {
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(Map.of("var1", "someValue"));
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        zeebeExtension.addVariablesToScope(processInstanceKey, Map.of("var1", "firstUpdate"), true);
        zeebeExtension.addVariablesToScope(processInstanceKey, Map.of("var1", "secondUpdate"), true);
        this.importAllZeebeEntitiesFromLastIndex();
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(2);
        this.importAllZeebeEntitiesFromLastIndex();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("secondUpdate"), "String"})});
    }

    @Test
    public void zeebeVariableImport_updateVariableSeveralTimesInSeveralBatches() {
        embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().setMaxImportPageSize(1);
        embeddedOptimizeExtension.reloadConfiguration();
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(Map.of("var1", "someValue"));
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        zeebeExtension.addVariablesToScope(processInstanceKey, Map.of("var1", "firstUpdate"), true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromLastIndex();
        zeebeExtension.addVariablesToScope(processInstanceKey, Map.of("var1", "secondUpdate"), true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(2);
        this.importAllZeebeEntitiesFromLastIndex();
        this.importAllZeebeEntitiesFromLastIndex();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("secondUpdate"), "String"})});
    }

    @Test
    public void zeebeVariableImport_updateObjectVariable() {
        HashMap<String, Object> objectVar = new HashMap<String, Object>();
        objectVar.put("name", "Pond");
        objectVar.put("age", 28);
        objectVar.put("likes", List.of("optimize", "garlic"));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("objectVar", objectVar);
        long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables(variables);
        this.waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        objectVar.put("age", 29);
        objectVar.put("likes", List.of("optimize", "garlic", "tofu"));
        zeebeExtension.addVariablesToScope(processInstanceKey, variables, true);
        this.waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(1);
        this.importAllZeebeEntitiesFromLastIndex();
        ProcessInstanceDto instance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)instance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getType, SimpleProcessVariableDto::getValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"objectVar", VariableType.OBJECT.getId(), Collections.singletonList(this.variablesClient.createMapJsonObjectVariableDto(objectVar).getValue())}), Tuple.tuple((Object[])new Object[]{"objectVar.name", VariableType.STRING.getId(), Collections.singletonList("Pond")}), Tuple.tuple((Object[])new Object[]{"objectVar.age", VariableType.DOUBLE.getId(), Collections.singletonList("29.0")}), Tuple.tuple((Object[])new Object[]{"objectVar.likes", VariableType.STRING.getId(), List.of("optimize", "garlic", "tofu")}), Tuple.tuple((Object[])new Object[]{"objectVar.likes._listSize", VariableType.LONG.getId(), Collections.singletonList("3")})});
    }

    private Map<String, Object> generateVariables() {
        return Map.of("var1", "someValue", "var2", false, "var3", 123, "var4", 123.3, "var5", "");
    }

    private Map<String, Object> generateUpdatedVariables() {
        return Map.of("var1", "var1UpdatedValue", "var2", true, "var3", 123.0, "var4", 123, "var5", "var5UpdatedValue");
    }

    private ProcessInstanceDto getProcessInstanceForId(String processInstanceId) {
        return (ProcessInstanceDto)databaseIntegrationTestExtension.getAllProcessInstances().stream().filter(instance -> instance.getProcessInstanceId().equals(processInstanceId)).collect(Collectors.toList()).stream().findFirst().orElseThrow(() -> new OptimizeIntegrationTestException("No process instance with id " + processInstanceId + "found"));
    }

    private void waitUntilMinimumVariableDocumentsWithCreatedIntentExportedCount(int minExportedEventCount) {
        this.waitUntilMinimumVariableDocumentsWithIntentExportedCount(minExportedEventCount, VariableIntent.CREATED);
    }

    private void waitUntilMinimumVariableDocumentsWithUpdatedIntentExportedCount(int minExportedEventCount) {
        this.waitUntilMinimumVariableDocumentsWithIntentExportedCount(minExportedEventCount, VariableIntent.UPDATED);
    }

    private void waitUntilMinimumVariableDocumentsWithIntentExportedCount(int minExportedEventCount, VariableIntent intent) {
        TermsQueryContainer variableBoolQuery = new TermsQueryContainer();
        variableBoolQuery.addTermQuery("intent", intent.name());
        this.waitUntilMinimumDataExportedCount(minExportedEventCount, "variable", variableBoolQuery);
    }

    private void assertThatVariablesHaveBeenImportedForProcessInstance(ProcessInstanceDto processInstanceDto) {
        Assertions.assertThat((List)processInstanceDto.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("var1UpdatedValue"), "String"}), Tuple.tuple((Object[])new Object[]{"var2", Collections.singletonList("true"), "Boolean"}), Tuple.tuple((Object[])new Object[]{"var3", Collections.singletonList("123.0"), "Double"}), Tuple.tuple((Object[])new Object[]{"var4", Collections.singletonList("123"), "Double"}), Tuple.tuple((Object[])new Object[]{"var5", Collections.singletonList("var5UpdatedValue"), "String"})});
    }

    private long deployProcessAndStartProcessInstanceWithVariables(Map<String, Object> variablesToAdd) {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("demoProcess"));
        return zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), variablesToAdd);
    }

    private ProcessInstanceEvent deployProcessAndStartProcessInstance() {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("demoProcess"));
        return zeebeExtension.startProcessInstanceForProcess(deployedProcess.getBpmnProcessId());
    }
}

