/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.client.api.response.Process;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.variable.SimpleProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.optimize.util.ZeebeBpmnModels;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZeebeVariableCreationImportIT
extends AbstractCCSMIT {
    private static final String PROCESS_ID = "demoProcess";
    private static final Map<String, Object> BASIC_VARIABLES = Map.of("var1", "someValue", "var2", false, "var3", 123, "var4", 123.3, "var5", "");
    private static final Map<String, Object> PERSON_VARIABLES = Map.of("name", "Pond", "age", 28, "IQ", 99999999999999L, "birthday", "1992-11-17T00:00:00+01:00", "muscleMassInPercent", 99.9, "deceased", false, "hands", (short)2, "likes", List.of("optimize", "garlic"), "skills", Map.of("read", true, "write", false));

    @BeforeEach
    public void setup() {
        embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().setIncludeObjectVariableValue(true);
    }

    @Test
    public void zeebeVariableImport_processStartedWithVariables() {
        Long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables();
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance);
    }

    @Test
    public void variableImportWorksForLongStrings() {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess(PROCESS_ID));
        String variableName = "longStringVar";
        String largeValue = RandomStringUtils.randomAlphabetic((int)Short.MAX_VALUE);
        Map<String, Object> variables = Map.of("longStringVar", largeValue);
        Long processInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), variables);
        this.waitUntilNumberOfDefinitionsExported(1);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto importedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        ((ObjectAssert)Assertions.assertThat((List)importedProcessInstance.getVariables()).singleElement()).satisfies(new ThrowingConsumer[]{variable -> {
            Assertions.assertThat((String)variable.getName()).isEqualTo("longStringVar");
            Assertions.assertThat((String)((String)variable.getValue().get(0))).isEqualTo(largeValue);
        }});
    }

    @Test
    public void zeebeVariableImport_variablesAddedAfterProcessStarted() {
        ProcessInstanceEvent processInstanceEvent = this.deployProcessAndStartProcessInstance();
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        zeebeExtension.addVariablesToScope(processInstanceEvent.getProcessInstanceKey(), BASIC_VARIABLES, false);
        this.waitUntilMinimumVariableDocumentsExportedCount(5);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceEvent.getProcessInstanceKey()));
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance);
    }

    @Test
    public void zeebeVariableImport_variablesWithSameNameOnDifferentScope() {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess(PROCESS_ID));
        long startedInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), Map.of("var1", "someValue"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(startedInstanceKey));
        String flowNodeId = this.getFlowNodeInstanceIdFromProcessInstanceForActivity(savedProcessInstance, "service_task");
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), Map.of("var1", false), true);
        this.waitUntilMinimumVariableDocumentsExportedCount(2);
        this.importAllZeebeEntitiesFromLastIndex();
        savedProcessInstance = this.getProcessInstanceForId(String.valueOf(startedInstanceKey));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("someValue"), "String"}), Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("false"), "Boolean"})});
    }

    @Test
    public void zeebeVariableImport_addNonLocalVariableToFlowNodeInstance() {
        Map<String, Object> processVariable = Map.of("var1", "someValue");
        ProcessInstanceEvent startedInstance = this.deployProcessAndStartProcessInstance();
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(startedInstance.getProcessInstanceKey()));
        String flowNodeId = this.getFlowNodeInstanceIdFromProcessInstanceForActivity(savedProcessInstance, "service_task");
        zeebeExtension.addVariablesToScope(Long.parseLong(flowNodeId), processVariable, false);
        this.waitUntilMinimumVariableDocumentsExportedCount(1);
        this.importAllZeebeEntitiesFromLastIndex();
        savedProcessInstance = this.getProcessInstanceForId(String.valueOf(startedInstance.getProcessInstanceKey()));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("someValue"), "String"})});
    }

    @Test
    public void zeebeVariableImport_variablesForMultipleInstancesStartedForSameProcess() {
        long deployedInstanceKey1 = this.deployProcessAndStartProcessInstanceWithVariables();
        long deployedInstanceKey2 = this.deployProcessAndStartProcessInstanceWithVariables();
        this.waitUntilMinimumProcessInstanceEventsExportedCount(8);
        this.waitUntilMinimumVariableDocumentsExportedCount(10);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance1 = this.getProcessInstanceForId(String.valueOf(deployedInstanceKey1));
        ProcessInstanceDto savedProcessInstance2 = this.getProcessInstanceForId(String.valueOf(deployedInstanceKey2));
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance1);
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance2);
    }

    @Test
    public void zeebeVariableImport_variablesForMultipleInstancesStartedForDifferentProcesses() {
        Process deployedProcess1 = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess(PROCESS_ID));
        long startedInstanceKey1 = this.deployProcessAndStartProcessInstanceWithVariables();
        Process deployedProcess2 = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess("second_process"));
        long startedInstanceKey2 = zeebeExtension.startProcessInstanceWithVariables(deployedProcess2.getBpmnProcessId(), BASIC_VARIABLES);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(8);
        this.waitUntilMinimumVariableDocumentsExportedCount(10);
        this.importAllZeebeEntitiesFromLastIndex();
        ProcessInstanceDto savedProcessInstance1 = this.getProcessInstanceForId(String.valueOf(startedInstanceKey1));
        ProcessInstanceDto savedProcessInstance2 = this.getProcessInstanceForId(String.valueOf(startedInstanceKey2));
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance1);
        this.assertThatVariablesHaveBeenImportedForProcessInstance(savedProcessInstance2);
    }

    @Test
    public void zeebeVariableImport_unsupportedTypesGetIgnored() {
        HashMap<String, Object> supportedAndUnsupportedVariables = new HashMap<String, Object>();
        supportedAndUnsupportedVariables.put("nullValue", null);
        supportedAndUnsupportedVariables.put("supportedVariable", "someValue");
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess(PROCESS_ID));
        long processInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), supportedAndUnsupportedVariables);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsExportedCount(2);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)savedProcessInstance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"supportedVariable", Collections.singletonList("someValue"), "String"})});
    }

    @Test
    public void zeebeVariableImport_importObjectVariables() {
        Map<String, Object> variables = Map.of("objectVar", PERSON_VARIABLES);
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess(PROCESS_ID));
        long processInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), variables);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto instance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)instance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getType, SimpleProcessVariableDto::getValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"objectVar", VariableType.OBJECT.getId(), Collections.singletonList(this.variablesClient.createMapJsonObjectVariableDto(PERSON_VARIABLES).getValue())}), Tuple.tuple((Object[])new Object[]{"objectVar.name", VariableType.STRING.getId(), Collections.singletonList("Pond")}), Tuple.tuple((Object[])new Object[]{"objectVar.age", VariableType.DOUBLE.getId(), Collections.singletonList("28.0")}), Tuple.tuple((Object[])new Object[]{"objectVar.IQ", VariableType.DOUBLE.getId(), Collections.singletonList("9.9999999999999E13")}), Tuple.tuple((Object[])new Object[]{"objectVar.birthday", VariableType.DATE.getId(), Collections.singletonList("1992-11-17T00:00:00.000+0100")}), Tuple.tuple((Object[])new Object[]{"objectVar.muscleMassInPercent", VariableType.DOUBLE.getId(), Collections.singletonList("99.9")}), Tuple.tuple((Object[])new Object[]{"objectVar.deceased", VariableType.BOOLEAN.getId(), Collections.singletonList("false")}), Tuple.tuple((Object[])new Object[]{"objectVar.hands", VariableType.DOUBLE.getId(), Collections.singletonList("2.0")}), Tuple.tuple((Object[])new Object[]{"objectVar.skills.read", VariableType.BOOLEAN.getId(), Collections.singletonList("true")}), Tuple.tuple((Object[])new Object[]{"objectVar.skills.write", VariableType.BOOLEAN.getId(), Collections.singletonList("false")}), Tuple.tuple((Object[])new Object[]{"objectVar.likes", VariableType.STRING.getId(), List.of("optimize", "garlic")}), Tuple.tuple((Object[])new Object[]{"objectVar.likes._listSize", VariableType.LONG.getId(), Collections.singletonList("2")})});
    }

    @Test
    public void zeebeVariableImport_importObjectVariablesWhenObjectVariablesAreExcludedInConfiguration() {
        embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().setIncludeObjectVariableValue(false);
        Map<String, Object> variables = Map.of("objectVar", PERSON_VARIABLES, "boolVar", true);
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess(PROCESS_ID));
        long processInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), variables);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto instance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)instance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getType, SimpleProcessVariableDto::getValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"boolVar", VariableType.BOOLEAN.getId(), Collections.singletonList("true")})});
    }

    @Test
    public void zeebeVariableImport_importListVariables() {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess(PROCESS_ID));
        long processInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), Map.of("listVar", List.of("value1", "value2")));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto instance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        Assertions.assertThat((List)instance.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getType, SimpleProcessVariableDto::getValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"listVar", VariableType.STRING.getId(), List.of("value1", "value2")}), Tuple.tuple((Object[])new Object[]{"listVar._listSize", VariableType.LONG.getId(), Collections.singletonList("2")})});
    }

    @Test
    public void zeebeVariableImport_importVariablesInBatches() {
        embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().setMaxImportPageSize(1);
        embeddedOptimizeExtension.reloadConfiguration();
        Map<String, Object> processVariables = Map.of("var1", "someValue1", "var2", "someValue2");
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess(PROCESS_ID));
        long startedInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), processVariables);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        zeebeExtension.addVariablesToScope(startedInstanceKey, processVariables, false);
        this.waitUntilMinimumVariableDocumentsExportedCount(2);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(startedInstanceKey));
        this.importAllZeebeEntitiesFromLastIndex();
        Assertions.assertThat((List)savedProcessInstance.getVariables()).hasSize(1);
        savedProcessInstance = this.getProcessInstanceForId(String.valueOf(startedInstanceKey));
        ((ListAssert)Assertions.assertThat((List)savedProcessInstance.getVariables()).hasSize(2)).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("someValue1"), "String"}), Tuple.tuple((Object[])new Object[]{"var2", Collections.singletonList("someValue2"), "String"})});
    }

    @Test
    public void zeebeVariableImport_importZeebeVariableDataFromMultipleDays() {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess(PROCESS_ID));
        long startedInstanceKey = zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), Map.of("var1", "someValue1"));
        try {
            zeebeExtension.setClock(Instant.now().plus(1L, ChronoUnit.DAYS));
        }
        catch (IOException | InterruptedException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        zeebeExtension.addVariablesToScope(startedInstanceKey, Map.of("var2", "someValue2"), false);
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.waitUntilMinimumVariableDocumentsExportedCount(2);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(startedInstanceKey));
        ((ListAssert)Assertions.assertThat((List)savedProcessInstance.getVariables()).hasSize(2)).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("someValue1"), "String"}), Tuple.tuple((Object[])new Object[]{"var2", Collections.singletonList("someValue2"), "String"})});
    }

    private ProcessInstanceDto getProcessInstanceForId(String processInstanceId) {
        return (ProcessInstanceDto)databaseIntegrationTestExtension.getAllProcessInstances().stream().filter(instance -> instance.getProcessInstanceId().equals(processInstanceId)).collect(Collectors.toList()).stream().findFirst().orElseThrow(() -> new OptimizeIntegrationTestException("No process instance with id " + processInstanceId + " found"));
    }

    private void waitUntilMinimumVariableDocumentsExportedCount(int minExportedEventCount) {
        TermsQueryContainer variableBoolQuery = new TermsQueryContainer();
        variableBoolQuery.addTermQuery("intent", VariableIntent.CREATED.name());
        this.waitUntilMinimumDataExportedCount(minExportedEventCount, "variable", variableBoolQuery);
    }

    private void assertThatVariablesHaveBeenImportedForProcessInstance(ProcessInstanceDto processInstanceDto) {
        Assertions.assertThat((List)processInstanceDto.getVariables()).extracting(new Function[]{SimpleProcessVariableDto::getName, SimpleProcessVariableDto::getValue, SimpleProcessVariableDto::getType}).containsExactlyInAnyOrder((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"var1", Collections.singletonList("someValue"), "String"}), Tuple.tuple((Object[])new Object[]{"var2", Collections.singletonList("false"), "Boolean"}), Tuple.tuple((Object[])new Object[]{"var3", Collections.singletonList("123"), "Double"}), Tuple.tuple((Object[])new Object[]{"var4", Collections.singletonList("123.3"), "Double"}), Tuple.tuple((Object[])new Object[]{"var5", Collections.singletonList(""), "String"})});
    }

    private ProcessInstanceEvent deployProcessAndStartProcessInstance() {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createSimpleServiceTaskProcess(PROCESS_ID));
        return zeebeExtension.startProcessInstanceForProcess(deployedProcess.getBpmnProcessId());
    }

    private Long deployProcessAndStartProcessInstanceWithVariables() {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess(PROCESS_ID));
        return zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), BASIC_VARIABLES);
    }
}

