/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.schema;

import io.camunda.optimize.service.db.es.schema.ElasticSearchSchemaManager;
import io.camunda.optimize.service.db.es.schema.index.DecisionInstanceIndexES;
import io.camunda.optimize.service.db.es.schema.index.ProcessInstanceIndexES;
import io.camunda.optimize.service.db.os.schema.OpenSearchSchemaManager;
import io.camunda.optimize.service.db.os.schema.index.DecisionInstanceIndexOS;
import io.camunda.optimize.service.db.os.schema.index.ProcessInstanceIndexOS;
import io.camunda.optimize.service.db.schema.IndexLookupUtil;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.util.configuration.DatabaseType;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class IndexLookupUtilTest {
    @Test
    public void allNonDynamicIndicesHaveMappingsFromElasticSearchToOpenSearch() {
        List<String> knownOpensearchNonDynamicIndexName = OpenSearchSchemaManager.getAllNonDynamicMappings().stream().map(IndexMappingCreator::getIndexName).toList();
        List<String> convertedIndexNames = ElasticSearchSchemaManager.getAllNonDynamicMappings().stream().map(esIndex -> IndexLookupUtil.convertIndexForDatabase((IndexMappingCreator)esIndex, (DatabaseType)DatabaseType.OPENSEARCH)).map(IndexMappingCreator::getIndexName).toList();
        Assertions.assertThat(convertedIndexNames).allSatisfy(convertedIndex -> Assertions.assertThat((String)convertedIndex).isIn((Iterable)knownOpensearchNonDynamicIndexName));
    }

    @Test
    public void allDynamicIndicesHaveMappingsFromElasticSearchToOpenSearch() {
        String defKey = "key";
        List<ProcessInstanceIndexES> dynamicESIndices = List.of(new DecisionInstanceIndexES("key"), new ProcessInstanceIndexES("key"));
        List<String> convertedIndexClassNames = dynamicESIndices.stream().map(esIndex -> IndexLookupUtil.convertIndexForDatabase((IndexMappingCreator)esIndex, (DatabaseType)DatabaseType.OPENSEARCH)).map(index -> index.getClass().getSimpleName()).toList();
        Assertions.assertThat(convertedIndexClassNames).containsExactlyInAnyOrderElementsOf(Stream.of(new DecisionInstanceIndexOS("key"), new ProcessInstanceIndexOS("key")).map(index -> index.getClass().getSimpleName()).toList());
    }

    @Test
    public void allNonDynamicIndicesHaveMappingsFromOpenSearchToElasticSearch() {
        List<String> knownElasticsearchNonDynamicIndexNames = ElasticSearchSchemaManager.getAllNonDynamicMappings().stream().map(IndexMappingCreator::getIndexName).toList();
        List<String> convertedIndexNames = OpenSearchSchemaManager.getAllNonDynamicMappings().stream().map(osIndex -> IndexLookupUtil.convertIndexForDatabase((IndexMappingCreator)osIndex, (DatabaseType)DatabaseType.ELASTICSEARCH)).map(IndexMappingCreator::getIndexName).toList();
        Assertions.assertThat(convertedIndexNames).allSatisfy(convertedIndex -> Assertions.assertThat((String)convertedIndex).isIn((Iterable)knownElasticsearchNonDynamicIndexNames));
    }

    @Test
    public void allDynamicIndicesHaveMappingsFromOpenSearchToElasticSearch() {
        String defKey = "key";
        List<ProcessInstanceIndexOS> dynamicOSIndices = List.of(new DecisionInstanceIndexOS("key"), new ProcessInstanceIndexOS("key"));
        List<String> convertedIndexClassNames = dynamicOSIndices.stream().map(esIndex -> IndexLookupUtil.convertIndexForDatabase((IndexMappingCreator)esIndex, (DatabaseType)DatabaseType.ELASTICSEARCH)).map(index -> index.getClass().getSimpleName()).toList();
        Assertions.assertThat(convertedIndexClassNames).containsExactlyInAnyOrderElementsOf(Stream.of(new DecisionInstanceIndexES("key"), new ProcessInstanceIndexES("key")).map(index -> index.getClass().getSimpleName()).toList());
    }
}

