/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.command.decision.mapping;

import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.dto.optimize.importing.InputInstanceDto;
import io.camunda.optimize.dto.optimize.importing.OutputInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.InputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.OutputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.RawDataDecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.VariableEntry;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.report.interpreter.util.RawDecisionDataResultDtoMapper;
import io.camunda.optimize.service.util.IdGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RawDataDecisionReportResultDtoMapperTest {
    @Test
    public void testMapFromSearchResponseHitCountNotEqualTotalCount() {
        int rawDataLimit = 2;
        RawDecisionDataResultDtoMapper mapper = new RawDecisionDataResultDtoMapper();
        List<DecisionInstanceDto> decisionInstanceDtos = this.generateInstanceList(2);
        List result = mapper.mapFrom(decisionInstanceDtos, Collections.emptySet(), Collections.emptySet());
        Assertions.assertThat((List)result).hasSize(2);
    }

    @Test
    public void testMapFromSearchResponseAdditionalVariablesAddedToResults() {
        RawDecisionDataResultDtoMapper mapper = new RawDecisionDataResultDtoMapper();
        List decisionInstanceDtos = this.generateInstanceList(5).stream().peek(instance -> {
            instance.setInputs(Arrays.asList(new InputInstanceDto(IdGenerator.getNextId(), "inputVarClauseId", "inputVarClauseName", VariableType.STRING, "in1")));
            instance.setOutputs(Arrays.asList(new OutputInstanceDto(IdGenerator.getNextId(), "outputVarClauseId", "outputVarClauseName", IdGenerator.getNextId(), Integer.valueOf(1), "outVarName", VariableType.STRING, "out1")));
        }).collect(Collectors.toList());
        List result = mapper.mapFrom(decisionInstanceDtos, new HashSet<InputVariableEntry>(Arrays.asList(new InputVariableEntry(IdGenerator.getNextId(), "newInputVarName", VariableType.STRING, (Object)"newInVal"))), new HashSet<OutputVariableEntry>(Arrays.asList(new OutputVariableEntry(IdGenerator.getNextId(), "newOutputVarName", VariableType.STRING, (Object)"newOutVal"))));
        Assertions.assertThat((List)result).extracting(RawDataDecisionInstanceDto::getInputVariables).allSatisfy(instanceInputVars -> Assertions.assertThat(instanceInputVars.values().stream().map(VariableEntry::getName).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"inputVarClauseName", "newInputVarName"}));
        Assertions.assertThat((List)result).extracting(RawDataDecisionInstanceDto::getOutputVariables).allSatisfy(instanceOutputVars -> Assertions.assertThat(instanceOutputVars.values().stream().map(VariableEntry::getName).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"outputVarClauseName", "newOutputVarName"}));
    }

    private List<DecisionInstanceDto> generateInstanceList(Integer rawDataLimit) {
        return IntStream.range(0, rawDataLimit).mapToObj(i -> new DecisionInstanceDto()).collect(Collectors.toList());
    }
}

