/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import com.icegreen.greenmail.util.DummySSLSocketFactory;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import io.camunda.optimize.dto.optimize.alert.AlertNotificationDto;
import io.camunda.optimize.dto.optimize.alert.AlertNotificationType;
import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.service.alert.AlertEmailNotificationService;
import io.camunda.optimize.service.email.EmailService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import io.camunda.optimize.service.util.configuration.EmailAuthenticationConfiguration;
import io.camunda.optimize.service.util.configuration.EmailSecurityProtocol;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@ExtendWith(value={MockitoExtension.class})
public class AlertEmailNotificationServiceTest {
    private ConfigurationService configurationService;
    private AlertEmailNotificationService notificationService;
    @Autowired
    private FreeMarkerConfigurer freemarkerConfigurer;
    private GreenMail greenMail;

    @BeforeEach
    public void init() {
        this.configurationService = ConfigurationServiceBuilder.createConfiguration().loadConfigurationFrom(new String[]{"service-config.yaml"}).build();
        this.configurationService.setEmailEnabled(Boolean.valueOf(true));
        this.configurationService.setNotificationEmailAddress("from@localhost.com");
        this.configurationService.setNotificationEmailHostname("127.0.0.1");
        this.configurationService.setNotificationEmailPort(Integer.valueOf(4444));
        EmailService emailService = new EmailService(this.configurationService, this.freemarkerConfigurer);
        this.notificationService = new AlertEmailNotificationService(this.configurationService, emailService);
    }

    @AfterEach
    public void cleanUp() {
        if (this.greenMail != null) {
            this.greenMail.stop();
        }
    }

    private void initGreenMail(String protocol) {
        this.greenMail = new GreenMail(new ServerSetup(4444, null, protocol));
        this.greenMail.start();
        this.greenMail.setUser("from@localhost.com", "demo", "demo");
    }

    @ParameterizedTest(name="test send email with security protocol = {0}")
    @MethodSource(value={"getSecurityProtocolVariations"})
    public void sendEmailWithSecurityProtocolVariations(EmailSecurityProtocol emailSecurityProtocol) {
        this.mockConfig(true, "demo", "demo", emailSecurityProtocol);
        this.initGreenMail("smtp");
        this.notificationService.notify(this.createEmailNotification("some body text", Collections.singletonList("to@localhost.com")));
        Object[] emails = this.greenMail.getReceivedMessages();
        Assertions.assertThat((Object[])emails).hasSize(1);
        Assertions.assertThat((String)GreenMailUtil.getBody((Part)emails[0])).isEqualTo("some body text&utm_medium=email");
    }

    @Test
    public void sendEmailWithSSLTLSProtocol() {
        Security.setProperty("ssl.SocketFactory.provider", DummySSLSocketFactory.class.getName());
        this.mockConfig(true, "demo", "demo", EmailSecurityProtocol.SSL_TLS);
        this.initGreenMail("smtps");
        this.notificationService.notify(this.createEmailNotification("some body text", Collections.singletonList("to@localhost.com")));
        Object[] emails = this.greenMail.getReceivedMessages();
        Assertions.assertThat((Object[])emails).hasSize(1);
        Assertions.assertThat((String)GreenMailUtil.getBody((Part)emails[0])).isEqualTo("some body text&utm_medium=email");
    }

    @Test
    public void sendEmailWithoutAuthenticationEnabled() {
        this.mockConfig(false, null, null, EmailSecurityProtocol.NONE);
        this.initGreenMail("smtp");
        this.notificationService.notify(this.createEmailNotification("some body text", Collections.singletonList("to@localhost.com")));
        Object[] emails = this.greenMail.getReceivedMessages();
        Assertions.assertThat((Object[])emails).hasSize(1);
        Assertions.assertThat((String)GreenMailUtil.getBody((Part)emails[0])).isEqualTo("some body text&utm_medium=email");
    }

    @Test
    public void notifyRecipientWithEmailDisabledDoesNotSendEmail() {
        this.configurationService.setEmailEnabled(Boolean.valueOf(false));
        this.mockConfig(true, "demo", "demo", EmailSecurityProtocol.NONE);
        this.initGreenMail("smtps");
        this.notificationService.notify(this.createEmailNotification("some body text", Collections.singletonList("to@localhost.com")));
        Object[] emails = this.greenMail.getReceivedMessages();
        Assertions.assertThat((Object[])emails).isEmpty();
    }

    @Test
    public void sendEmailToMultipleRecipients() throws MessagingException {
        this.mockConfig(true, "demo", "demo", EmailSecurityProtocol.NONE);
        this.initGreenMail("smtp");
        this.notificationService.notify(this.createEmailNotification("some body text", List.of("to1@localhost.com", "to2@localhost.com")));
        Object[] emails = this.greenMail.getReceivedMessages();
        Assertions.assertThat((Object[])emails).hasSize(2);
        Assertions.assertThat((Object)emails[0].getRecipients(Message.RecipientType.TO)[0]).hasToString("to1@localhost.com");
        Assertions.assertThat((Object)emails[1].getRecipients(Message.RecipientType.TO)[0]).hasToString("to2@localhost.com");
    }

    @Test
    public void sendEmailToRemainingRecipientsIfOneFails() throws MessagingException {
        this.mockConfig(true, "demo", "demo", EmailSecurityProtocol.NONE);
        this.initGreenMail("smtp");
        this.notificationService.notify(this.createEmailNotification("some body text", List.of("invalidAddressThatThrowsError", "to2@localhost.com")));
        Object[] emails = this.greenMail.getReceivedMessages();
        Assertions.assertThat((Object[])emails).hasSize(1);
        Assertions.assertThat((Object)emails[0].getRecipients(Message.RecipientType.TO)[0]).hasToString("to2@localhost.com");
    }

    @Test
    public void notifyRecipientsFails() {
        this.mockConfig(true, "demo", "demo", EmailSecurityProtocol.NONE);
        this.initGreenMail("smtp");
        this.notificationService.notify(this.createEmailNotification("some body text", List.of("invalidAddressThatThrowsError")));
        Object[] emails = this.greenMail.getReceivedMessages();
        Assertions.assertThat((Object[])emails).isEmpty();
    }

    private static Stream<EmailSecurityProtocol> getSecurityProtocolVariations() {
        return Stream.of(EmailSecurityProtocol.NONE, EmailSecurityProtocol.STARTTLS);
    }

    private void mockConfig(boolean authenticationEnabled, String username, String password, EmailSecurityProtocol securityProtocol) {
        EmailAuthenticationConfiguration emailAuthenticationConfiguration = this.configurationService.getEmailAuthenticationConfiguration();
        emailAuthenticationConfiguration.setEnabled(Boolean.valueOf(authenticationEnabled));
        emailAuthenticationConfiguration.setUsername(username);
        emailAuthenticationConfiguration.setPassword(password);
        emailAuthenticationConfiguration.setSecurityProtocol(securityProtocol);
    }

    private AlertNotificationDto createEmailNotification(String text, List<String> recipients) {
        AlertDefinitionDto alertDefinitionDto = new AlertDefinitionDto();
        alertDefinitionDto.setEmails(recipients);
        return new AlertNotificationDto(alertDefinitionDto, Double.valueOf(0.0), AlertNotificationType.NEW, text, "linkToReport");
    }
}

