/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.analysis.DurationChartEntryDto;
import io.camunda.optimize.dto.optimize.query.analysis.FindingsDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierVariableParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.OutlierAnalysisServiceParameters;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessDefinitionParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessInstanceIdDto;
import io.camunda.optimize.dto.optimize.query.analysis.VariableTermDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.OutlierAnalysisService;
import io.camunda.optimize.service.db.reader.DurationOutliersReader;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class OutlierAnalysisServiceTest {
    private static final String USER_ID = "unauthorized-user";
    private static final String PROCESS_DEFINITION_KEY = "test-process";
    private static final List<String> TENANT_IDS = List.of("tenant1");
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService = (DataSourceDefinitionAuthorizationService)Mockito.mock(DataSourceDefinitionAuthorizationService.class);
    private final DurationOutliersReader outliersReader = (DurationOutliersReader)Mockito.mock(DurationOutliersReader.class);
    private final OutlierAnalysisService outlierAnalysisService = new OutlierAnalysisService(this.definitionAuthorizationService, this.outliersReader);

    @Test
    void shouldReturnFlowNodeOutlierMapWhenUserIsAuthorized() {
        OutlierAnalysisServiceParameters<ProcessDefinitionParametersDto> params = this.getAnalysisServiceParametersWithAuthMock(new ProcessDefinitionParametersDto(), true);
        Map<String, FindingsDto> expectedResult = Map.of("node1", new FindingsDto());
        Mockito.when((Object)this.outliersReader.getFlowNodeOutlierMap(params)).thenReturn(expectedResult);
        Map result = this.outlierAnalysisService.getFlowNodeOutlierMap(params);
        AssertionsForClassTypes.assertThat((Object)result).isEqualTo(expectedResult);
    }

    @Test
    void shouldReturnCountByDurationChartWhenUserIsAuthorized() {
        OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> params = this.getAnalysisServiceParametersWithAuthMock(new FlowNodeOutlierParametersDto(), true);
        List<DurationChartEntryDto> expectedResult = List.of(new DurationChartEntryDto());
        Mockito.when((Object)this.outliersReader.getCountByDurationChart(params)).thenReturn(expectedResult);
        List result = this.outlierAnalysisService.getCountByDurationChart(params);
        AssertionsForClassTypes.assertThat((Object)result).isEqualTo(expectedResult);
    }

    @Test
    void shouldReturnSignificantOutlierVariableTermsWhenUserIsAuthorized() {
        OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> params = this.getAnalysisServiceParametersWithAuthMock(new FlowNodeOutlierParametersDto(), true);
        List<VariableTermDto> expectedResult = List.of(new VariableTermDto());
        Mockito.when((Object)this.outliersReader.getSignificantOutlierVariableTerms(params)).thenReturn(expectedResult);
        List result = this.outlierAnalysisService.getSignificantOutlierVariableTerms(params);
        AssertionsForClassTypes.assertThat((Object)result).isEqualTo(expectedResult);
    }

    @Test
    void shouldReturnSignificantOutlierVariableTermsInstanceIdsWhenUserIsAuthorized() {
        OutlierAnalysisServiceParameters<FlowNodeOutlierVariableParametersDto> params = this.getAnalysisServiceParametersWithAuthMock(new FlowNodeOutlierVariableParametersDto(), true);
        List<ProcessInstanceIdDto> expectedResult = List.of(new ProcessInstanceIdDto());
        Mockito.when((Object)this.outliersReader.getSignificantOutlierVariableTermsInstanceIds(params)).thenReturn(expectedResult);
        List result = this.outlierAnalysisService.getSignificantOutlierVariableTermsInstanceIds(params);
        AssertionsForClassTypes.assertThat((Object)result).isEqualTo(expectedResult);
    }

    @Test
    void shouldThrowForbiddenExceptionFlowNodeOutlierMapWhenUserIsNotAuthorized() {
        OutlierAnalysisServiceParameters<ProcessDefinitionParametersDto> params = this.getAnalysisServiceParametersWithAuthMock(new ProcessDefinitionParametersDto(), false);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> this.outlierAnalysisService.getFlowNodeOutlierMap(params)).isInstanceOf(ForbiddenException.class)).hasMessage("Current user is not authorized to access data of the provided process definition and tenant combination");
    }

    @Test
    void shouldThrowForbiddenExceptionCountByDurationChartWhenUserIsNotAuthorized() {
        OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> params = this.getAnalysisServiceParametersWithAuthMock(new FlowNodeOutlierParametersDto(), false);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> this.outlierAnalysisService.getCountByDurationChart(params)).isInstanceOf(ForbiddenException.class)).hasMessage("Current user is not authorized to access data of the provided process definition and tenant combination");
    }

    @Test
    void shouldThrowForbiddenExceptionSignificantOutlierVariableTermsWhenUserIsNotAuthorized() {
        OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> params = this.getAnalysisServiceParametersWithAuthMock(new FlowNodeOutlierParametersDto(), false);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> this.outlierAnalysisService.getSignificantOutlierVariableTerms(params)).isInstanceOf(ForbiddenException.class)).hasMessage("Current user is not authorized to access data of the provided process definition and tenant combination");
    }

    @Test
    void shouldThrowForbiddenExceptionSignificantVariableTermsInstanceIdsWhenUserIsNotAuthorized() {
        OutlierAnalysisServiceParameters<FlowNodeOutlierVariableParametersDto> params = this.getAnalysisServiceParametersWithAuthMock(new FlowNodeOutlierVariableParametersDto(), false);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> this.outlierAnalysisService.getSignificantOutlierVariableTermsInstanceIds(params)).isInstanceOf(ForbiddenException.class)).hasMessage("Current user is not authorized to access data of the provided process definition and tenant combination");
    }

    private <T extends ProcessDefinitionParametersDto> OutlierAnalysisServiceParameters<T> getAnalysisServiceParametersWithAuthMock(T processDefinitionParams, boolean auth) {
        Mockito.when((Object)this.definitionAuthorizationService.isAuthorizedToAccessDefinition(USER_ID, DefinitionType.PROCESS, PROCESS_DEFINITION_KEY, TENANT_IDS)).thenReturn((Object)auth);
        processDefinitionParams.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
        processDefinitionParams.setTenantIds(TENANT_IDS);
        return new OutlierAnalysisServiceParameters(processDefinitionParams, ZoneOffset.systemDefault(), USER_ID);
    }
}

