/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.providers;

import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.tomcat.CacheRequestInterceptor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

@ExtendWith(value={MockitoExtension.class})
public class CacheRequestFilterTest {
    final ModelAndView modelAndView = null;
    private final HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    private final HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private final HandlerMethod handlerMethod = (HandlerMethod)Mockito.mock(HandlerMethod.class);
    private final Method method = (Method)Mockito.mock(Method.class);
    private final CacheRequestInterceptor underTest = new CacheRequestInterceptor();

    public CacheRequestFilterTest() {
        Mockito.when((Object)this.handlerMethod.getMethod()).thenReturn((Object)this.method);
        Mockito.when((Object)this.method.isAnnotationPresent((Class)ArgumentMatchers.any())).thenReturn((Object)true);
    }

    @Test
    public void filterSetsCacheControlMaxAge() throws Exception {
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)HttpStatus.OK.value());
        OffsetDateTime now = OffsetDateTime.parse("2019-04-23T18:00:00+01:00");
        LocalDateUtil.setCurrentTime((OffsetDateTime)now);
        this.underTest.postHandle(this.request, this.response, (Object)this.handlerMethod, this.modelAndView);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader("Cache-Control", "max-age=21600");
    }

    @Test
    public void filterDoesNotOverwritePreviousCacheControlHeaders() throws Exception {
        Mockito.when((Object)this.response.getHeader("Cache-Control")).thenReturn((Object)"no-store");
        this.underTest.postHandle(this.request, this.response, (Object)this.handlerMethod, this.modelAndView);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)0))).addHeader((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"unsuccessfulResponses"})
    public void filterIsNotSetOnUnsuccessfulResponse(HttpStatus status) throws Exception {
        Mockito.when((Object)this.response.getStatus()).thenReturn((Object)status.value());
        OffsetDateTime now = OffsetDateTime.parse("2019-04-23T18:00:00+01:00");
        LocalDateUtil.setCurrentTime((OffsetDateTime)now);
        this.underTest.postHandle(this.request, this.response, (Object)this.handlerMethod, this.modelAndView);
        Assertions.assertThat((String)this.response.getHeader("Cache-Control")).isNull();
    }

    private static Stream<HttpStatus> unsuccessfulResponses() {
        return Stream.of(HttpStatus.BAD_REQUEST, HttpStatus.NOT_FOUND, HttpStatus.FORBIDDEN);
    }
}

