/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.auth;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.rest.security.ccsm.CCSMSecurityConfigurerAdapter;
import io.camunda.optimize.rest.security.cloud.CCSaaSSecurityConfigurerAdapter;
import java.util.Date;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.test.util.ReflectionTestUtils;

@WireMockTest
public class JwtDecoderIT
extends AbstractCCSMIT {
    private final WireMockRuntimeInfo wireMockInfo;
    private final String authServerMockUrl;

    public JwtDecoderIT(WireMockRuntimeInfo wireMockInfo) {
        this.wireMockInfo = wireMockInfo;
        this.authServerMockUrl = wireMockInfo.getHttpBaseUrl();
    }

    @BeforeEach
    public void setup() {
        embeddedOptimizeExtension.getConfigurationService().getOptimizeApiConfiguration().setJwtSetUri(this.authServerMockUrl + "/protocol/openid-connect/certs");
        embeddedOptimizeExtension.getConfigurationService().getAuthConfiguration().getCloudAuthConfiguration().setAudience("optimize");
        embeddedOptimizeExtension.getConfigurationService().getAuthConfiguration().getCloudAuthConfiguration().setClusterId("456");
        embeddedOptimizeExtension.getConfigurationService().getAuthConfiguration().getCcsmAuthConfiguration().setAudience("optimize");
    }

    @ParameterizedTest
    @MethodSource(value={"decoderProvider"})
    public void testDecodeRs256JwtWithNoAlgFieldInJwkResponse(String type, String methodName) throws JOSEException {
        RSAKey rsaJWK = this.getRsaJWK(JWSAlgorithm.RS256);
        String serializedJwt = JwtDecoderIT.signAndSerialize(rsaJWK, JWSAlgorithm.RS256);
        String publicKey = rsaJWK.toPublicJWK().toJSONString();
        JwtDecoder decoder = JwtDecoderIT.createDecoder(methodName, type);
        String withoutAlg = publicKey.replaceFirst("\"alg\":\".*\",", "");
        String authServerResponseBody = "{\"keys\":[" + withoutAlg + "]}";
        org.junit.jupiter.api.Assertions.assertFalse((boolean)authServerResponseBody.contains("alg\":"));
        this.wireMockInfo.getWireMock().register(WireMock.get((UrlPattern)WireMock.urlMatching((String)".*/protocol/openid-connect/certs")).willReturn(WireMock.jsonResponse((String)authServerResponseBody, (int)HttpStatus.OK.value())));
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> decoder.decode(serializedJwt));
        this.wireMockInfo.getWireMock().verifyThat(1, RequestPatternBuilder.allRequests());
    }

    @ParameterizedTest
    @MethodSource(value={"decoderProvider"})
    public void testDecodeRs256Jwt(String type, String methodName) throws JOSEException {
        RSAKey rsaJWK = this.getRsaJWK(JWSAlgorithm.RS256);
        String serializedJwt = JwtDecoderIT.signAndSerialize(rsaJWK, JWSAlgorithm.RS256);
        String publicKey = rsaJWK.toPublicJWK().toJSONString();
        JwtDecoder decoder = JwtDecoderIT.createDecoder(methodName, type);
        String authServerResponseBody = "{\"keys\":[" + publicKey + "]}";
        this.wireMockInfo.getWireMock().register(WireMock.get((UrlPattern)WireMock.urlMatching((String)".*/protocol/openid-connect/certs")).willReturn(WireMock.jsonResponse((String)authServerResponseBody, (int)HttpStatus.OK.value())));
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> decoder.decode(serializedJwt));
        this.wireMockInfo.getWireMock().verifyThat(1, RequestPatternBuilder.allRequests());
    }

    @ParameterizedTest
    @MethodSource(value={"decoderProvider"})
    public void testDecodeRs256JwtExpired(String type, String methodName) throws JOSEException {
        RSAKey rsaJWK = this.getRsaJWK(JWSAlgorithm.RS256);
        String serializedJwt = JwtDecoderIT.signAndSerialize(rsaJWK, JWSAlgorithm.RS256, JwtDecoderIT.getExpiredClaimsSet());
        String publicKey = rsaJWK.toPublicJWK().toJSONString();
        JwtDecoder decoder = JwtDecoderIT.createDecoder(methodName, type);
        String authServerResponseBody = "{\"keys\":[" + publicKey + "]}";
        this.wireMockInfo.getWireMock().register(WireMock.get((UrlPattern)WireMock.urlMatching((String)".*/protocol/openid-connect/certs")).willReturn(WireMock.jsonResponse((String)authServerResponseBody, (int)HttpStatus.OK.value())));
        Exception exception = (Exception)org.junit.jupiter.api.Assertions.assertThrows(JwtValidationException.class, () -> decoder.decode(serializedJwt));
        this.wireMockInfo.getWireMock().verifyThat(1, RequestPatternBuilder.allRequests());
        Assertions.assertThat((String)exception.getMessage()).containsIgnoringCase((CharSequence)"Jwt expired");
    }

    @ParameterizedTest
    @MethodSource(value={"decoderProvider"})
    public void testDecodeRs256JwtInvalidSignature(String type, String methodName) throws JOSEException {
        RSAKey rsaJWK = this.getRsaJWK(JWSAlgorithm.RS256);
        String serializedJwt = JwtDecoderIT.signAndSerialize(rsaJWK, JWSAlgorithm.RS256);
        String publicKey = rsaJWK.toPublicJWK().toJSONString();
        JwtDecoder decoder = JwtDecoderIT.createDecoder(methodName, type);
        String authServerResponseBody = "{\"keys\":[" + publicKey + "]}";
        this.wireMockInfo.getWireMock().register(WireMock.get((UrlPattern)WireMock.urlMatching((String)".*/protocol/openid-connect/certs")).willReturn(WireMock.jsonResponse((String)authServerResponseBody, (int)HttpStatus.OK.value())));
        String[] jwtParts = serializedJwt.split("\\.");
        if (jwtParts.length != 3) {
            throw new RuntimeException("Invalid JWT token format");
        }
        String unsignedJwt = jwtParts[0] + "." + jwtParts[1] + ".anySignature";
        Exception exception = (Exception)org.junit.jupiter.api.Assertions.assertThrows(BadJwtException.class, () -> decoder.decode(unsignedJwt));
        this.wireMockInfo.getWireMock().verifyThat(1, RequestPatternBuilder.allRequests());
        Assertions.assertThat((String)exception.getMessage()).containsIgnoringCase((CharSequence)"Invalid Signature");
    }

    private RSAKey getRsaJWK(JWSAlgorithm alg) throws JOSEException {
        return (RSAKey)new RSAKeyGenerator(2048).keyID("123").keyUse(KeyUse.SIGNATURE).algorithm((Algorithm)alg).generate();
    }

    public static String signAndSerialize(RSAKey rsaKey, JWSAlgorithm alg, JWTClaimsSet claimsSet) throws JOSEException {
        RSASSASigner rsaSigner = new RSASSASigner(rsaKey);
        SignedJWT rsaSignedJWT = new SignedJWT(new JWSHeader.Builder(alg).type(JOSEObjectType.JWT).keyID(rsaKey.getKeyID()).build(), claimsSet);
        rsaSignedJWT.sign((JWSSigner)rsaSigner);
        return rsaSignedJWT.serialize();
    }

    public static String signAndSerialize(RSAKey rsaKey, JWSAlgorithm alg) throws JOSEException {
        return JwtDecoderIT.signAndSerialize(rsaKey, alg, JwtDecoderIT.getDefaultClaimsSet());
    }

    public static JWTClaimsSet getDefaultClaimsSet() {
        return new JWTClaimsSet.Builder().subject("alice").audience("optimize").issuer("http://localhost").claim("https://camunda.com/clusterId", (Object)"456").expirationTime(new Date(new Date().getTime() + 60000L)).build();
    }

    public static JWTClaimsSet getExpiredClaimsSet() {
        return new JWTClaimsSet.Builder().subject("alice").audience("optimize").issuer("http://localhost").claim("https://camunda.com/clusterId", (Object)"456").expirationTime(new Date(System.currentTimeMillis() - 100000L)).build();
    }

    private static JwtDecoder createDecoder(String methodName, String type) {
        CCSaaSSecurityConfigurerAdapter configurerAdapter;
        if ("SaaS".equalsIgnoreCase(type)) {
            configurerAdapter = new CCSaaSSecurityConfigurerAdapter(embeddedOptimizeExtension.getConfigurationService(), null, null, null, null, null);
        } else if ("CCSM".equalsIgnoreCase(type)) {
            configurerAdapter = new CCSMSecurityConfigurerAdapter(embeddedOptimizeExtension.getConfigurationService(), null, null, null, null);
        } else {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return (JwtDecoder)ReflectionTestUtils.invokeMethod((Object)configurerAdapter, (String)methodName, (Object[])new Object[0]);
    }

    static Stream<Arguments> decoderProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"SaaS", "publicApiJwtDecoder"}), Arguments.of((Object[])new Object[]{"CCSM", "publicApiJwtDecoder"}), Arguments.of((Object[])new Object[]{"SaaS", "publicApiJwtDecoder"}));
    }
}

