/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import io.camunda.optimize.rest.util.TimeZoneUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;

public class ResponseTimezoneFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseTimezoneFilter.class);

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        ZoneId timezone = TimeZoneUtil.extractTimezone(servletRequest);
        Optional.ofNullable(RequestContextHolder.getRequestAttributes()).ifPresent(attrs -> attrs.setAttribute("X-Optimize-Client-Timezone", (Object)timezone.getId(), 0));
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

