/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StreamUtils;

public class ExternalResourcesUtil
extends HttpServlet {
    private static final String INDEX_FILE = "/index.html";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final Map<String, String> MIME_TYPE_MAP = new HashMap<String, String>();

    public static void serveStaticResource(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, String clusterId) throws ServletException, IOException {
        String filename = request.getRequestURI().replaceFirst("/external", "");
        filename = ExternalResourcesUtil.stripContextPath(filename, request);
        if ("/".equals(filename = ExternalResourcesUtil.stripClusterIdPath(filename, clusterId)) || filename.isEmpty()) {
            filename = INDEX_FILE;
        }
        try {
            InputStream fileStream = servletContext.getResourceAsStream(filename);
            String mimeType = ExternalResourcesUtil.getMimeType(filename);
            response.setContentType(mimeType != null ? mimeType : DEFAULT_MIME_TYPE);
            StreamUtils.copy((InputStream)fileStream, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (Exception exception) {
            throw new IOException("Cannot stream external resource: " + filename, exception);
        }
    }

    public static boolean shouldServeStaticResource(HttpServletRequest request, String clusterId) {
        String requestURI = request.getRequestURI();
        requestURI = ExternalResourcesUtil.stripContextPath(requestURI, request);
        boolean result = (requestURI = ExternalResourcesUtil.stripClusterIdPath(requestURI, clusterId)) != null && requestURI.startsWith("/external") && !requestURI.startsWith("/external/api") && "GET".equals(request.getMethod());
        return result;
    }

    public static String getMimeType(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return DEFAULT_MIME_TYPE;
        }
        String extension = ExternalResourcesUtil.getFileExtension(fileName);
        return MIME_TYPE_MAP.getOrDefault(extension, DEFAULT_MIME_TYPE);
    }

    private static String getFileExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            return fileName.substring(lastDotIndex + 1).toLowerCase();
        }
        return "";
    }

    public static String stripContextPath(String filename, HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String newName = filename;
        if (!contextPath.isEmpty() && filename.startsWith(contextPath)) {
            newName = filename.substring(contextPath.length());
        }
        return newName;
    }

    private static String stripClusterIdPath(String filename, String clusterId) {
        if (clusterId == null || clusterId.isEmpty()) {
            return filename;
        }
        String clusterPath = "/" + clusterId;
        String newName = filename;
        if (filename.startsWith(clusterPath)) {
            newName = filename.substring(clusterPath.length());
        }
        return newName;
    }

    public static void serveStaticResource(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException, IOException {
        ExternalResourcesUtil.serveStaticResource(request, response, servletContext, null);
    }

    public static boolean shouldServeStaticResource(HttpServletRequest request) {
        return ExternalResourcesUtil.shouldServeStaticResource(request, null);
    }

    static {
        MIME_TYPE_MAP.put("pdf", "application/pdf");
        MIME_TYPE_MAP.put("png", "image/png");
        MIME_TYPE_MAP.put("jpg", "image/jpeg");
        MIME_TYPE_MAP.put("jpeg", "image/jpeg");
        MIME_TYPE_MAP.put("gif", "image/gif");
        MIME_TYPE_MAP.put("html", "text/html");
        MIME_TYPE_MAP.put("css", "text/css");
        MIME_TYPE_MAP.put("js", "application/javascript");
        MIME_TYPE_MAP.put("json", "application/json");
        MIME_TYPE_MAP.put("xml", "application/xml");
        MIME_TYPE_MAP.put("txt", "text/plain");
    }
}

