/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public final class DurationFormatterUtil {
    private DurationFormatterUtil() {
    }

    public static String formatMilliSecondsToReadableDurationString(long durationInMs) {
        if (durationInMs <= 0L) {
            return "-";
        }
        long years = TimeUnit.MILLISECONDS.toDays(durationInMs) / 365L;
        long months = TimeUnit.MILLISECONDS.toDays(durationInMs -= TimeUnit.DAYS.toMillis(years * 365L)) / 30L;
        long weeks = TimeUnit.MILLISECONDS.toDays(durationInMs -= TimeUnit.DAYS.toMillis(months * 30L)) / 7L;
        long days = TimeUnit.MILLISECONDS.toDays(durationInMs -= TimeUnit.DAYS.toMillis(weeks * 7L));
        long hours = TimeUnit.MILLISECONDS.toHours(durationInMs -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(durationInMs -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(durationInMs -= TimeUnit.MINUTES.toMillis(minutes));
        durationInMs -= TimeUnit.SECONDS.toMillis(seconds);
        StringBuilder sb = new StringBuilder();
        if (years > 0L) {
            sb.append(String.format("%dyrs", years));
        }
        if (months > 0L) {
            sb.append(String.format(" %dmo", months));
        }
        if (weeks > 0L) {
            sb.append(String.format(" %dwks", weeks));
        }
        if (days > 0L) {
            sb.append(String.format(" %dd", days));
        }
        if (hours > 0L) {
            sb.append(String.format(" %dh", hours));
        }
        if (minutes > 0L) {
            sb.append(String.format(" %dmin", minutes));
        }
        if (seconds > 0L) {
            sb.append(String.format(" %ds", seconds));
        }
        if (durationInMs > 0L) {
            sb.append(String.format(" %dms", durationInMs));
        }
        return StringUtils.strip((String)sb.toString());
    }

    public static String formatDuration(String unitString, long duration) {
        return duration <= 0L ? "" : String.format("%d%s", duration, unitString);
    }
}

