/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security.util.tenant;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.security.util.tenant.DataSourceTenantAuthorizationService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import io.camunda.optimize.service.util.importing.ZeebeConstants;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={CCSMCondition.class})
@Component
public class CamundaCCSMTenantAuthorizationService
implements DataSourceTenantAuthorizationService {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaCCSMTenantAuthorizationService.class);
    private final CCSMTokenService ccsmTokenService;
    private final ConfigurationService configurationService;
    private final Cache<String, List<TenantDto>> userTenantAuthorizations;

    public CamundaCCSMTenantAuthorizationService(CCSMTokenService ccsmTokenService, ConfigurationService configurationService) {
        this.ccsmTokenService = ccsmTokenService;
        this.configurationService = configurationService;
        this.userTenantAuthorizations = Caffeine.newBuilder().maximumSize((long)configurationService.getCaches().getCloudTenantAuthorizations().getMaxSize()).expireAfterWrite((long)configurationService.getCaches().getCloudTenantAuthorizations().getDefaultTtlMillis(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    public boolean isAuthorizedToSeeAllTenants(String identityId, IdentityType identityType, List<String> tenantIds) {
        return this.isCurrentUserAuthorizedToSeeAllTenants(tenantIds);
    }

    @Override
    public boolean isAuthorizedToSeeTenant(String identityId, IdentityType identityType, String tenantId) {
        return this.isCurrentUserAuthorizedToSeeTenant(tenantId);
    }

    @Override
    public boolean isAuthorizedToSeeTenant(String identityId, IdentityType identityType, String tenantId, String dataSourceName) {
        return this.isCurrentUserAuthorizedToSeeTenant(tenantId);
    }

    public Map<String, TenantDto> getCurrentUserTenantAuthorizations() {
        return this.getCurrentUserAuthorizedTenants().stream().collect(Collectors.toMap(TenantDto::getId, Function.identity()));
    }

    public List<TenantDto> getCurrentUserAuthorizedTenants() {
        if (this.configurationService.isMultiTenancyEnabled()) {
            Optional<String> currentUserId = this.getCurrentUserId();
            if (currentUserId.isEmpty()) {
                LOG.warn("Unable to determine currently logged in user ID to retrieve tenant authorizations.");
                return Collections.emptyList();
            }
            Optional<List> userTenantAuths = Optional.ofNullable((List)this.userTenantAuthorizations.getIfPresent((Object)currentUserId.get()));
            if (userTenantAuths.isEmpty()) {
                this.repopulateCacheWithCurrentUserTenantAuthorization();
                userTenantAuths = Optional.ofNullable((List)this.userTenantAuthorizations.getIfPresent((Object)currentUserId.get()));
            }
            return userTenantAuths.orElse(Collections.emptyList());
        }
        return Collections.singletonList(ZeebeConstants.ZEEBE_DEFAULT_TENANT);
    }

    private boolean isCurrentUserAuthorizedToSeeAllTenants(List<String> tenantIds) {
        return tenantIds.stream().allMatch(this::isCurrentUserAuthorizedToSeeTenant);
    }

    private boolean isCurrentUserAuthorizedToSeeTenant(String tenantId) {
        return this.getCurrentUserAuthorizedTenants().stream().anyMatch(tenant -> Objects.equals(tenantId, tenant.getId()));
    }

    private void repopulateCacheWithCurrentUserTenantAuthorization() {
        this.getCurrentUserId().ifPresent(id -> this.userTenantAuthorizations.put(id, this.fetchCurrentUserAuthorizedTenants()));
    }

    private List<TenantDto> fetchCurrentUserAuthorizedTenants() {
        return this.ccsmTokenService.getCurrentUserAuthToken().map(this.ccsmTokenService::getAuthorizedTenantsFromToken).orElse(Collections.emptyList());
    }

    private Optional<String> getCurrentUserId() {
        return this.ccsmTokenService.getCurrentUserIdFromAuthToken();
    }
}

