/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ReportAuthorizationService {
    private final AbstractIdentityService identityService;
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService;
    private final AuthorizedCollectionService collectionAuthorizationService;
    private final ReportReader reportReader;

    public ReportAuthorizationService(AbstractIdentityService identityService, DataSourceDefinitionAuthorizationService definitionAuthorizationService, AuthorizedCollectionService collectionAuthorizationService, ReportReader reportReader) {
        this.identityService = identityService;
        this.definitionAuthorizationService = definitionAuthorizationService;
        this.collectionAuthorizationService = collectionAuthorizationService;
        this.reportReader = reportReader;
    }

    public boolean isAuthorizedToReport(String userId, ReportDefinitionDto<?> report) {
        return this.getAuthorizedRole(userId, report).isPresent();
    }

    public Optional<RoleType> getAuthorizedRole(String userId, ReportDefinitionDto<?> report) {
        Optional<RoleType> authorizedRole = this.getAuthorizedReportRole(userId, report);
        return authorizedRole.filter(role -> this.isAuthorizedToAccessReportDefinition(userId, report));
    }

    private Optional<RoleType> getAuthorizedReportRole(String userId, ReportDefinitionDto<?> report) {
        RoleType role = null;
        if (report.getCollectionId() != null) {
            role = this.collectionAuthorizationService.getUsersCollectionResourceRole(userId, report.getCollectionId()).orElse(null);
        } else if (report.getData() instanceof ProcessReportDataDto && ((ProcessReportDataDto)report.getData()).isInstantPreviewReport()) {
            role = this.isAuthorizedToAccessProcessReportDefinition(userId, (ProcessReportDataDto)report.getData()) ? RoleType.VIEWER : null;
        } else if (Optional.ofNullable(report.getOwner()).map(owner -> owner.equals(userId)).orElse(true).booleanValue()) {
            role = RoleType.EDITOR;
        }
        return Optional.ofNullable(role);
    }

    public boolean isAuthorizedToAccessReportDefinition(String userId, ReportDefinitionDto<?> report) {
        boolean authorizedToAccessDefinition;
        if (report instanceof SingleProcessReportDefinitionRequestDto) {
            ProcessReportDataDto reportData = (ProcessReportDataDto)((SingleProcessReportDefinitionRequestDto)report).getData();
            authorizedToAccessDefinition = this.isAuthorizedToAccessProcessReportDefinition(userId, reportData);
        } else if (report instanceof SingleDecisionReportDefinitionRequestDto) {
            DecisionReportDataDto reportData = (DecisionReportDataDto)((SingleDecisionReportDefinitionRequestDto)report).getData();
            authorizedToAccessDefinition = this.isAuthorizedToAccessDecisionReportDefinition(userId, reportData);
        } else if (report instanceof CombinedReportDefinitionRequestDto) {
            CombinedReportDataDto reportData = (CombinedReportDataDto)((CombinedReportDefinitionRequestDto)report).getData();
            authorizedToAccessDefinition = this.reportReader.getAllSingleProcessReportsForIdsOmitXml(reportData.getReportIds()).stream().allMatch(r -> this.isAuthorizedToAccessProcessReportDefinition(userId, (ProcessReportDataDto)r.getData()));
        } else {
            throw new OptimizeRuntimeException("Unsupported report type: " + report.getClass().getSimpleName());
        }
        return authorizedToAccessDefinition;
    }

    private boolean isAuthorizedToAccessDecisionReportDefinition(String userId, DecisionReportDataDto reportData) {
        if (userId == null) {
            throw new IllegalArgumentException("userId cannot be null");
        }
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
        return this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, DefinitionType.DECISION, reportData.getDecisionDefinitionKey(), reportData.getTenantIds());
    }

    private boolean isAuthorizedToAccessProcessReportDefinition(String userId, ProcessReportDataDto reportData) {
        if (userId == null) {
            throw new IllegalArgumentException("userId cannot be null");
        }
        if (reportData == null) {
            throw new IllegalArgumentException("reportData cannot be null");
        }
        return reportData.getDefinitions().stream().allMatch(definition -> this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, DefinitionType.PROCESS, definition.getKey(), definition.getTenantIds()));
    }
}

