/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.relations;

import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.service.relations.ReportReferencingService;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ReportRelationService {
    private final List<ReportReferencingService> referencingServices;

    @Lazy
    public ReportRelationService(List<ReportReferencingService> referencingServices) {
        this.referencingServices = referencingServices;
    }

    public Set<ConflictedItemDto> getConflictedItemsForDeleteReport(ReportDefinitionDto reportDefinition) {
        LinkedHashSet<ConflictedItemDto> conflictedItems = new LinkedHashSet<ConflictedItemDto>();
        for (ReportReferencingService referencingService : this.referencingServices) {
            conflictedItems.addAll(referencingService.getConflictedItemsForReportDelete(reportDefinition));
        }
        return conflictedItems;
    }

    public Set<ConflictedItemDto> getConflictedItemsForUpdatedReport(ReportDefinitionDto currentDefinition, ReportDefinitionDto updateDefinition) {
        LinkedHashSet<ConflictedItemDto> conflictedItems = new LinkedHashSet<ConflictedItemDto>();
        for (ReportReferencingService referencingService : this.referencingServices) {
            conflictedItems.addAll(referencingService.getConflictedItemsForReportUpdate(currentDefinition, updateDefinition));
        }
        return conflictedItems;
    }

    public void handleDeleted(ReportDefinitionDto reportDefinition) {
        for (ReportReferencingService referencingService : this.referencingServices) {
            referencingService.handleReportDeleted(reportDefinition);
        }
    }

    public void handleUpdated(String reportId, ReportDefinitionDto updateDefinition) {
        for (ReportReferencingService referencingService : this.referencingServices) {
            referencingService.handleReportUpdated(reportId, updateDefinition);
        }
    }
}

