/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.mixpanel;

import io.camunda.optimize.service.mixpanel.MixpanelDataService;
import io.camunda.optimize.service.mixpanel.client.EventReportingEvent;
import io.camunda.optimize.service.mixpanel.client.MixpanelClient;
import io.camunda.optimize.service.mixpanel.client.MixpanelEvent;
import io.camunda.optimize.service.mixpanel.client.MixpanelEventProperties;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class MixpanelReportingService {
    private final MixpanelDataService mixpanelDataService;
    private final MixpanelClient mixpanelClient;

    public MixpanelReportingService(MixpanelDataService mixpanelDataService, MixpanelClient mixpanelClient) {
        this.mixpanelDataService = mixpanelDataService;
        this.mixpanelClient = mixpanelClient;
    }

    public void sendHeartbeatData() {
        this.mixpanelClient.importEvent(new MixpanelEvent(EventReportingEvent.HEARTBEAT, (MixpanelEventProperties)this.mixpanelDataService.getMixpanelHeartbeatProperties()));
    }

    public void sendEntityEvent(EventReportingEvent event, String entityId) {
        this.mixpanelClient.importEvent(new MixpanelEvent(event, (MixpanelEventProperties)this.mixpanelDataService.getMixpanelEntityEventProperties(entityId)));
    }
}

