/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.importing.ImportIndexHandlerRegistry;
import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.engine.service.ObjectVariableService;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeVariableImportService;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeVariableFetcher;
import io.camunda.optimize.service.importing.zeebe.mediator.ZeebeVariableImportMediator;
import io.camunda.optimize.service.importing.zeebe.mediator.factory.AbstractZeebeImportMediatorFactory;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.stereotype.Component;

@Component
public class ZeebeVariableImportMediatorFactory
extends AbstractZeebeImportMediatorFactory {
    private final ProcessInstanceWriter zeebeProcessInstanceWriter;
    private final ProcessDefinitionReader processDefinitionReader;
    private final ObjectVariableService objectVariableService;

    public ZeebeVariableImportMediatorFactory(BeanFactory beanFactory, ImportIndexHandlerRegistry importIndexHandlerRegistry, ConfigurationService configurationService, ProcessInstanceWriter zeebeProcessInstanceWriter, ObjectMapper objectMapper, DatabaseClient databaseClient, ProcessDefinitionReader processDefinitionReader, ObjectVariableService objectVariableService) {
        super(beanFactory, importIndexHandlerRegistry, configurationService, objectMapper, databaseClient);
        this.zeebeProcessInstanceWriter = zeebeProcessInstanceWriter;
        this.processDefinitionReader = processDefinitionReader;
        this.objectVariableService = objectVariableService;
    }

    @Override
    public List<ImportMediator> createMediators(ZeebeDataSourceDto zeebeDataSourceDto) {
        return Collections.singletonList(new ZeebeVariableImportMediator(this.importIndexHandlerRegistry.getZeebeVariableImportIndexHandler(zeebeDataSourceDto.getPartitionId()), (ZeebeVariableFetcher)this.beanFactory.getBean(ZeebeVariableFetcher.class, new Object[]{zeebeDataSourceDto.getPartitionId(), this.databaseClient, this.objectMapper, this.configurationService}), new ZeebeVariableImportService(this.configurationService, this.zeebeProcessInstanceWriter, zeebeDataSourceDto.getPartitionId(), new ObjectMapper(), this.processDefinitionReader, this.objectVariableService, this.databaseClient), this.configurationService, new BackoffCalculator(this.configurationService)));
    }
}

