/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator;

import io.camunda.optimize.MetricEnum;
import io.camunda.optimize.OptimizeMetrics;
import io.camunda.optimize.dto.zeebe.incident.ZeebeIncidentRecordDto;
import io.camunda.optimize.service.importing.PositionBasedImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.MediatorRank;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeIncidentImportService;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeIncidentFetcher;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeIncidentImportIndexHandler;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ZeebeIncidentImportMediator
extends PositionBasedImportMediator<ZeebeIncidentImportIndexHandler, ZeebeIncidentRecordDto> {
    private final ZeebeIncidentFetcher zeebeIncidentFetcher;

    public ZeebeIncidentImportMediator(ZeebeIncidentImportIndexHandler importIndexHandler, ZeebeIncidentFetcher zeebeIncidentFetcher, ZeebeIncidentImportService importService, ConfigurationService configurationService, BackoffCalculator idleBackoffCalculator) {
        this.importIndexHandler = importIndexHandler;
        this.zeebeIncidentFetcher = zeebeIncidentFetcher;
        this.importService = importService;
        this.configurationService = configurationService;
        this.idleBackoffCalculator = idleBackoffCalculator;
    }

    @Override
    public MediatorRank getRank() {
        return MediatorRank.INSTANCE_SUB_ENTITIES;
    }

    @Override
    protected boolean importNextPage(Runnable importCompleteCallback) {
        return this.importNextPagePositionBased(this.getIncidents(), importCompleteCallback);
    }

    @Override
    protected String getRecordType() {
        return ValueType.INCIDENT.name();
    }

    @Override
    protected Integer getPartitionId() {
        return this.zeebeIncidentFetcher.getPartitionId();
    }

    private List<ZeebeIncidentRecordDto> getIncidents() {
        return (List)OptimizeMetrics.getTimer(MetricEnum.NEW_PAGE_FETCH_TIME_METRIC, this.getRecordType(), this.getPartitionId()).record(() -> this.zeebeIncidentFetcher.getZeebeRecordsForPrefixAndPartitionFrom(((ZeebeIncidentImportIndexHandler)this.importIndexHandler).getNextPage()));
    }
}

