/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.handler;

import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.service.importing.PositionBasedImportIndexHandler;
import io.camunda.optimize.service.importing.ZeebeImportIndexHandler;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ZeebeImportIndexHandlerProvider {
    private static final List<Class<?>> POSITION_BASED_HANDLER_CLASSES;
    private final ZeebeDataSourceDto zeebeDataSourceDto;
    @Autowired
    private BeanFactory beanFactory;
    private Map<String, PositionBasedImportIndexHandler> positionBasedHandlersByName;

    public ZeebeImportIndexHandlerProvider(ZeebeDataSourceDto zeebeDataSourceDto) {
        this.zeebeDataSourceDto = zeebeDataSourceDto;
    }

    @PostConstruct
    public void init() {
        this.positionBasedHandlersByName = new HashMap<String, PositionBasedImportIndexHandler>();
        POSITION_BASED_HANDLER_CLASSES.forEach(clazz -> {
            PositionBasedImportIndexHandler importIndexHandlerInstance = (PositionBasedImportIndexHandler)this.getImportIndexHandlerInstance(this.zeebeDataSourceDto, clazz);
            this.positionBasedHandlersByName.put(clazz.getSimpleName(), importIndexHandlerInstance);
        });
    }

    public List<PositionBasedImportIndexHandler> getPositionBasedImportHandlers() {
        return new ArrayList<PositionBasedImportIndexHandler>(this.positionBasedHandlersByName.values());
    }

    public <C extends ZeebeImportIndexHandler> C getImportIndexHandler(Class<C> clazz) {
        return (C)this.positionBasedHandlersByName.get(clazz.getSimpleName());
    }

    private <R, C extends Class<R>> R getImportIndexHandlerInstance(ZeebeDataSourceDto zeebeDataSourceDto, C requiredType) {
        Object result = this.isInstantiated(requiredType) ? requiredType.cast(this.positionBasedHandlersByName.get(requiredType.getSimpleName())) : this.beanFactory.getBean(requiredType, new Object[]{zeebeDataSourceDto});
        return result;
    }

    private boolean isInstantiated(Class<?> handlerClass) {
        return this.positionBasedHandlersByName.get(handlerClass.getSimpleName()) != null;
    }

    static {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().acceptPackages(new String[]{ZeebeImportIndexHandlerProvider.class.getPackage().getName()}).scan();){
            POSITION_BASED_HANDLER_CLASSES = scanResult.getSubclasses(PositionBasedImportIndexHandler.class.getName()).loadClasses();
        }
    }
}

