/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.fetcher.es;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.importing.page.PositionBasedImportPage;
import io.camunda.optimize.service.importing.zeebe.fetcher.AbstractZeebeRecordFetcher;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Conditional(value={ElasticSearchCondition.class})
public abstract class AbstractZeebeRecordFetcherES<T>
extends AbstractZeebeRecordFetcher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractZeebeRecordFetcherES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;

    protected AbstractZeebeRecordFetcherES(int partitionId, OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, ConfigurationService configurationService) {
        super(partitionId, configurationService);
        this.esClient = esClient;
        this.objectMapper = objectMapper;
    }

    @Override
    protected List<T> fetchZeebeRecordsForPrefixAndPartitionFrom(PositionBasedImportPage positionBasedImportPage) throws Exception {
        SearchResponse searchResponse = this.esClient.searchWithoutPrefixing(SearchRequest.of(s -> s.index(this.getIndexAlias(), new String[0]).query(this.getRecordQuery(positionBasedImportPage)).size(Integer.valueOf(this.getDynamicBatchSize())).sort(ss -> ss.field(f -> f.field(this.getSortField(positionBasedImportPage)).order(SortOrder.Asc))).routing(String.valueOf(this.partitionId)).requestCache(Boolean.valueOf(false))), this.getRecordDtoClass());
        if (!searchResponse.shards().failures().isEmpty() || searchResponse.shards().total().intValue() > searchResponse.shards().failed().intValue() + searchResponse.shards().successful().intValue()) {
            throw new OptimizeRuntimeException("Not all shards could be searched successfully");
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), this.getRecordDtoClass(), this.objectMapper);
    }

    @Override
    protected boolean isZeebeInstanceIndexNotFoundException(Exception e) {
        if (e instanceof ElasticsearchException) {
            return e.getMessage().contains("index_not_found_exception");
        }
        return false;
    }

    private Query getRecordQuery(PositionBasedImportPage positionBasedImportPage) {
        if (!positionBasedImportPage.isHasSeenSequenceField() || this.nextSequenceRecordIsBeyondSequenceQuery(positionBasedImportPage)) {
            return this.buildPositionQuery(positionBasedImportPage);
        }
        return this.buildSequenceQuery(positionBasedImportPage);
    }

    private boolean nextSequenceRecordIsBeyondSequenceQuery(PositionBasedImportPage positionBasedImportPage) {
        block6: {
            if (this.getConsecutiveEmptyPages() < this.getZeebeImportConfig().getMaxEmptyPagesToImport()) {
                return false;
            }
            CountRequest countRequest = CountRequest.of(c -> c.index(this.getIndexAlias(), new String[0]).query(this.buildPositionQuery(positionBasedImportPage)).routing(String.valueOf(this.partitionId)));
            try {
                LOG.info("Using the position query to see if there are new records in the {} index on partition {}", (Object)this.getBaseIndexName(), (Object)this.partitionId);
                long numberOfRecordsFound = this.esClient.countWithoutPrefix(countRequest);
                if (numberOfRecordsFound > 0L) {
                    LOG.info("Found {} records in index {} on partition {} that can't be imported by the current sequence query. Will revert to position query for the next fetch attempt", new Object[]{numberOfRecordsFound, this.getBaseIndexName(), this.partitionId});
                    return true;
                }
                LOG.info("There are no newer records to process, so empty pages of records are currently expected");
            }
            catch (Exception e) {
                if (this.isZeebeInstanceIndexNotFoundException(e)) {
                    LOG.warn("No Zeebe index of type {} found to count records from!", (Object)this.getIndexAlias());
                } else {
                    LOG.warn("There was an error when looking for records to import beyond the boundaries of the sequence request" + String.valueOf(e));
                }
                if (!(e instanceof InterruptedException)) break block6;
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private Query buildPositionQuery(PositionBasedImportPage positionBasedImportPage) {
        LOG.trace("using position query for records of {} on partition {}", (Object)this.getBaseIndexName(), (Object)this.getPartitionId());
        return Query.of(q -> q.bool(m -> m.must(u -> u.range(r -> r.field("position").gt(JsonData.of((Object)positionBasedImportPage.getPosition())))).must(u -> u.term(r -> r.field("partitionId").value((long)this.partitionId)))));
    }

    private Query buildSequenceQuery(PositionBasedImportPage positionBasedImportPage) {
        LOG.trace("using sequence query for records of {} on partition {}", (Object)this.getBaseIndexName(), (Object)this.getPartitionId());
        return Query.of(q -> q.bool(m -> m.must(u -> u.range(r -> r.field("sequence").gt(JsonData.of((Object)positionBasedImportPage.getSequence())).lte(JsonData.of((Object)(positionBasedImportPage.getSequence() + (long)this.getDynamicBatchSize())))))));
    }
}

