/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.fetcher;

import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.importing.page.PositionBasedImportPage;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ZeebeImportConfiguration;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZeebeRecordFetcher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractZeebeRecordFetcher.class);
    protected final int partitionId;
    protected final ConfigurationService configurationService;
    private int dynamicBatchSize;
    private int consecutiveSuccessfulFetches;
    private int consecutiveEmptyPages;
    private Deque<Integer> batchSizeDeque;

    protected AbstractZeebeRecordFetcher(int partitionId, ConfigurationService configurationService) {
        this.partitionId = partitionId;
        this.configurationService = configurationService;
        this.initializeDynamicBatchSizing(configurationService);
        this.initializeDynamicFetching();
    }

    public List<T> getZeebeRecordsForPrefixAndPartitionFrom(PositionBasedImportPage positionBasedImportPage) {
        List<T> results;
        try {
            results = this.fetchZeebeRecordsForPrefixAndPartitionFrom(positionBasedImportPage);
        }
        catch (Exception e) {
            if (this.isZeebeInstanceIndexNotFoundException(e)) {
                LOG.warn("No Zeebe index with alias {} found to read records from!", (Object)this.getIndexAlias());
                return Collections.emptyList();
            }
            if (e instanceof IOException) {
                this.dynamicallyReduceBatchSizeForNextAttempt();
            }
            String errorMessage = String.format("Was not able to retrieve zeebe records of type %s from partition %s", this.getBaseIndexName(), this.partitionId);
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        this.markFetchAsSuccessfulAndAdjustBatchSize();
        this.trackConsecutiveEmptyPages(results);
        return results;
    }

    protected abstract boolean isZeebeInstanceIndexNotFoundException(Exception var1);

    protected abstract List<T> fetchZeebeRecordsForPrefixAndPartitionFrom(PositionBasedImportPage var1) throws Exception;

    protected abstract String getBaseIndexName();

    protected abstract Class<T> getRecordDtoClass();

    protected String getSortField(PositionBasedImportPage positionBasedImportPage) {
        return positionBasedImportPage.isHasSeenSequenceField() ? "sequence" : "position";
    }

    protected String getIndexAlias() {
        return this.configurationService.getConfiguredZeebe().getName() + "-" + this.getBaseIndexName();
    }

    protected ZeebeImportConfiguration getZeebeImportConfig() {
        return this.configurationService.getConfiguredZeebe().getImportConfig();
    }

    private void initializeDynamicFetching() {
        this.consecutiveEmptyPages = 0;
    }

    private void initializeDynamicBatchSizing(ConfigurationService configurationService) {
        this.dynamicBatchSize = configurationService.getConfiguredZeebe().getMaxImportPageSize();
        this.consecutiveSuccessfulFetches = 0;
        this.batchSizeDeque = new ArrayDeque<Integer>();
    }

    private void dynamicallyReduceBatchSizeForNextAttempt() {
        if (this.dynamicBatchSize > 1) {
            int newBatchSize = this.dynamicBatchSize / 2;
            if (!this.batchSizeDeque.contains(newBatchSize)) {
                this.batchSizeDeque.push(newBatchSize);
            }
            this.dynamicBatchSize = newBatchSize;
            LOG.info("Dynamically reducing import page size to {} for next fetch attempt for type {} from partition {}", new Object[]{this.dynamicBatchSize, this.getBaseIndexName(), this.partitionId});
        }
    }

    private void markFetchAsSuccessfulAndAdjustBatchSize() {
        int configuredDefaultBatchSize = this.configurationService.getConfiguredZeebe().getMaxImportPageSize();
        if (this.dynamicBatchSize != configuredDefaultBatchSize && this.consecutiveSuccessfulFetches < this.getZeebeImportConfig().getDynamicBatchSuccessAttempts()) {
            ++this.consecutiveSuccessfulFetches;
            if (this.consecutiveSuccessfulFetches >= this.getZeebeImportConfig().getDynamicBatchSuccessAttempts()) {
                if (!this.batchSizeDeque.isEmpty()) {
                    this.dynamicBatchSize = this.batchSizeDeque.pop();
                } else {
                    LOG.debug("Dynamic resizing complete, can now revert batch size back to default of {}", (Object)configuredDefaultBatchSize);
                    this.dynamicBatchSize = configuredDefaultBatchSize;
                }
                LOG.info("Reverting batch size back to {} for fetching of {} records from partition {}", new Object[]{this.dynamicBatchSize, this.getBaseIndexName(), this.partitionId});
                this.consecutiveSuccessfulFetches = 0;
            }
        }
    }

    private void trackConsecutiveEmptyPages(List<T> results) {
        this.consecutiveEmptyPages = results.isEmpty() ? (this.consecutiveEmptyPages < this.getZeebeImportConfig().getMaxEmptyPagesToImport() ? ++this.consecutiveEmptyPages : 0) : 0;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public int getDynamicBatchSize() {
        return this.dynamicBatchSize;
    }

    public int getConsecutiveSuccessfulFetches() {
        return this.consecutiveSuccessfulFetches;
    }

    public int getConsecutiveEmptyPages() {
        return this.consecutiveEmptyPages;
    }

    public Deque<Integer> getBatchSizeDeque() {
        return this.batchSizeDeque;
    }
}

