/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service.zeebe;

import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.importing.DatabaseImportJob;
import io.camunda.optimize.service.importing.DatabaseImportJobExecutor;
import io.camunda.optimize.service.importing.engine.service.ImportService;
import io.camunda.optimize.service.importing.job.ProcessInstanceDatabaseImportJob;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZeebeProcessInstanceSubEntityImportService<T>
implements ImportService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeProcessInstanceSubEntityImportService.class);
    protected final DatabaseImportJobExecutor databaseImportJobExecutor;
    protected final ConfigurationService configurationService;
    protected final ProcessDefinitionReader processDefinitionReader;
    protected final int partitionId;
    private final ProcessInstanceWriter processInstanceWriter;
    private final DatabaseClient databaseClient;
    private final String sourceExportIndex;

    protected ZeebeProcessInstanceSubEntityImportService(ConfigurationService configurationService, ProcessInstanceWriter processInstanceWriter, int partitionId, ProcessDefinitionReader processDefinitionReader, DatabaseClient databaseClient, String sourceExportIndex) {
        this.databaseImportJobExecutor = new DatabaseImportJobExecutor(this.getClass().getSimpleName(), configurationService);
        this.processInstanceWriter = processInstanceWriter;
        this.partitionId = partitionId;
        this.configurationService = configurationService;
        this.processDefinitionReader = processDefinitionReader;
        this.databaseClient = databaseClient;
        this.sourceExportIndex = sourceExportIndex;
    }

    abstract List<ProcessInstanceDto> filterAndMapZeebeRecordsToOptimizeEntities(List<T> var1);

    @Override
    public void executeImport(List<T> zeebeRecords, Runnable importCompleteCallback) {
        boolean newDataIsAvailable;
        boolean bl = newDataIsAvailable = !zeebeRecords.isEmpty();
        if (newDataIsAvailable) {
            List<ProcessInstanceDto> newOptimizeEntities = this.filterAndMapZeebeRecordsToOptimizeEntities(zeebeRecords);
            DatabaseImportJob<ProcessInstanceDto> databaseImportJob = this.createDatabaseImportJob(newOptimizeEntities, importCompleteCallback);
            this.addDatabaseImportJobToQueue(databaseImportJob);
        }
    }

    @Override
    public DatabaseImportJobExecutor getDatabaseImportJobExecutor() {
        return this.databaseImportJobExecutor;
    }

    protected ProcessInstanceDto createSkeletonProcessInstance(String processDefinitionKey, Long processInstanceId, Long processDefinitionId, String tenantId) {
        ProcessInstanceDto processInstanceDto = new ProcessInstanceDto();
        processInstanceDto.setProcessDefinitionKey(processDefinitionKey);
        processInstanceDto.setProcessInstanceId(String.valueOf(processInstanceId));
        processInstanceDto.setProcessDefinitionId(String.valueOf(processDefinitionId));
        processInstanceDto.setTenantId(tenantId);
        processInstanceDto.setDataSource((DataSourceDto)new ZeebeDataSourceDto(this.configurationService.getConfiguredZeebe().getName(), this.partitionId));
        return processInstanceDto;
    }

    private void addDatabaseImportJobToQueue(DatabaseImportJob<ProcessInstanceDto> databaseImportJob) {
        this.databaseImportJobExecutor.executeImportJob(databaseImportJob);
    }

    private DatabaseImportJob<ProcessInstanceDto> createDatabaseImportJob(List<ProcessInstanceDto> processInstanceDtos, Runnable importCompleteCallback) {
        ProcessInstanceDatabaseImportJob processInstanceImportJob = new ProcessInstanceDatabaseImportJob(this.processInstanceWriter, this.configurationService, importCompleteCallback, this.sourceExportIndex, this.databaseClient);
        processInstanceImportJob.setEntitiesToImport(processInstanceDtos);
        return processInstanceImportJob;
    }
}

