/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service.zeebe;

import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.dto.zeebe.definition.ZeebeProcessDefinitionDataDto;
import io.camunda.optimize.dto.zeebe.definition.ZeebeProcessDefinitionRecordDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.writer.ProcessDefinitionWriter;
import io.camunda.optimize.service.importing.DatabaseImportJob;
import io.camunda.optimize.service.importing.DatabaseImportJobExecutor;
import io.camunda.optimize.service.importing.engine.service.ImportService;
import io.camunda.optimize.service.importing.job.ProcessDefinitionDatabaseImportJob;
import io.camunda.optimize.service.util.BpmnModelUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeProcessDefinitionImportService
implements ImportService<ZeebeProcessDefinitionRecordDto> {
    private static final Set<ProcessIntent> INTENTS_TO_IMPORT = Set.of(ProcessIntent.CREATED);
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeProcessDefinitionImportService.class);
    private final DatabaseImportJobExecutor databaseImportJobExecutor;
    private final ProcessDefinitionWriter processDefinitionWriter;
    private final ConfigurationService configurationService;
    private final int partitionId;
    private final DatabaseClient databaseClient;

    public ZeebeProcessDefinitionImportService(ConfigurationService configurationService, ProcessDefinitionWriter processDefinitionWriter, int partitionId, DatabaseClient databaseClient) {
        this.databaseImportJobExecutor = new DatabaseImportJobExecutor(this.getClass().getSimpleName(), configurationService);
        this.processDefinitionWriter = processDefinitionWriter;
        this.partitionId = partitionId;
        this.configurationService = configurationService;
        this.databaseClient = databaseClient;
    }

    @Override
    public void executeImport(List<ZeebeProcessDefinitionRecordDto> pageOfProcessDefinitions, Runnable importCompleteCallback) {
        boolean newDataIsAvailable;
        LOG.trace("Importing process definitions from zeebe records...");
        boolean bl = newDataIsAvailable = !pageOfProcessDefinitions.isEmpty();
        if (newDataIsAvailable) {
            List<ProcessDefinitionOptimizeDto> newOptimizeEntities = this.filterAndMapZeebeRecordsToOptimizeEntities(pageOfProcessDefinitions);
            DatabaseImportJob<ProcessDefinitionOptimizeDto> databaseImportJob = this.createDatabaseImportJob(newOptimizeEntities, importCompleteCallback);
            this.addDatabaseImportJobToQueue(databaseImportJob);
        }
    }

    @Override
    public DatabaseImportJobExecutor getDatabaseImportJobExecutor() {
        return this.databaseImportJobExecutor;
    }

    private void addDatabaseImportJobToQueue(DatabaseImportJob<ProcessDefinitionOptimizeDto> databaseImportJob) {
        this.databaseImportJobExecutor.executeImportJob(databaseImportJob);
    }

    private List<ProcessDefinitionOptimizeDto> filterAndMapZeebeRecordsToOptimizeEntities(List<ZeebeProcessDefinitionRecordDto> zeebeRecords) {
        List<ProcessDefinitionOptimizeDto> optimizeDtos = zeebeRecords.stream().filter(zeebeRecord -> INTENTS_TO_IMPORT.contains(zeebeRecord.getIntent())).map(this::mapZeebeRecordsToOptimizeEntities).collect(Collectors.toList());
        LOG.debug("Processing {} fetched zeebe process definition records, of which {} are relevant to Optimize and will be imported.", (Object)zeebeRecords.size(), (Object)optimizeDtos.size());
        return optimizeDtos;
    }

    private DatabaseImportJob<ProcessDefinitionOptimizeDto> createDatabaseImportJob(List<ProcessDefinitionOptimizeDto> processDefinitions, Runnable importCompleteCallback) {
        ProcessDefinitionDatabaseImportJob procDefImportJob = new ProcessDefinitionDatabaseImportJob(this.processDefinitionWriter, importCompleteCallback, this.databaseClient);
        procDefImportJob.setEntitiesToImport(processDefinitions);
        return procDefImportJob;
    }

    private ProcessDefinitionOptimizeDto mapZeebeRecordsToOptimizeEntities(ZeebeProcessDefinitionRecordDto zeebeProcessDefinitionRecord) {
        ZeebeProcessDefinitionDataDto recordData = (ZeebeProcessDefinitionDataDto)zeebeProcessDefinitionRecord.getValue();
        String bpmn = new String(recordData.getResource(), StandardCharsets.UTF_8);
        return ProcessDefinitionOptimizeDto.builder().id(String.valueOf(recordData.getProcessDefinitionKey())).key(String.valueOf(recordData.getBpmnProcessId())).version(String.valueOf(recordData.getVersion())).versionTag((String)Optional.ofNullable(recordData.getVersionTag()).filter(tag -> !tag.isEmpty()).orElse(null)).name(BpmnModelUtil.extractProcessDefinitionName(String.valueOf(recordData.getBpmnProcessId()), bpmn).orElse(recordData.getBpmnProcessId())).bpmn20Xml(bpmn).dataSource((DataSourceDto)new ZeebeDataSourceDto(this.configurationService.getConfiguredZeebe().getName(), this.partitionId)).tenantId(recordData.getTenantId()).deleted(false).flowNodeData(BpmnModelUtil.extractFlowNodeData(bpmn)).userTaskNames(BpmnModelUtil.extractUserTaskNames(bpmn)).build();
    }
}

